/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class FromFileDoNotDeleteFileIfProcessFailsTest
extends ContextTestSupport {
    private String body = "Hello World this file will NOT be deleted";

    @Override
    protected void setUp() throws Exception {
        FromFileDoNotDeleteFileIfProcessFailsTest.deleteDirectory("target/deletefile");
        super.setUp();
    }

    public void testPollFileAndShouldNotBeDeleted() throws Exception {
        this.template.sendBodyAndHeader("file://target/deletefile", (Object)this.body, "CamelFileName", (Object)"hello.txt");
        MockEndpoint mock = this.getMockEndpoint("mock:error");
        mock.expectedMinimumMessageCount(1);
        mock.assertIsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File file = new File("target/deletefile/hello.txt");
        FromFileDoNotDeleteFileIfProcessFailsTest.assertTrue((String)"The file should NOT have been deleted", (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).to("mock:error");
                this.from("file://target/deletefile?delete=true").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IllegalArgumentException("Forced by unittest");
                    }
                });
            }
        };
    }
}

