/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileToFileNioLowBufferTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileToFileNioLowBufferTest.deleteDirectory("target/nio");
        super.setUp();
    }

    public void testFileToFileNioLowBuffer() throws Exception {
        String body = "1234567890123456789012345678901234567890";
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists("target/nio/out/hello.txt", body);
        this.template.sendBodyAndHeader("file://target/nio/in", (Object)body, "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("file://target/nio/in").convertBodyTo(String.class)).to("file://target/nio/out?bufferSize=4")).to("mock:result");
            }
        };
    }
}

