/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileRecursiveDepthTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileRecursiveDepthTest.deleteDirectory("target/depth");
        super.setUp();
    }

    public void testDepth() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"a2", "b2"});
        this.template.sendBodyAndHeader("file:target/depth", (Object)"a", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader("file:target/depth", (Object)"b", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader("file:target/depth/foo", (Object)"a2", "CamelFileName", (Object)"a2.txt");
        this.template.sendBodyAndHeader("file:target/depth/foo/bar", (Object)"a3", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader("file:target/depth/bar", (Object)"b2", "CamelFileName", (Object)"b2.txt");
        this.template.sendBodyAndHeader("file:target/depth/bar/foo", (Object)"b3", "CamelFileName", (Object)"b.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testDepthMin2Max99() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"a2", "b2", "a3", "b3"});
        this.template.sendBodyAndHeader("file:target/depth2", (Object)"a", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader("file:target/depth2", (Object)"b", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader("file:target/depth2/bar", (Object)"b2", "CamelFileName", (Object)"b2.txt");
        this.template.sendBodyAndHeader("file:target/depth2/foo", (Object)"a2", "CamelFileName", (Object)"a2.txt");
        this.template.sendBodyAndHeader("file:target/depth2/foo/bar", (Object)"a3", "CamelFileName", (Object)"a3.txt");
        this.template.sendBodyAndHeader("file:target/depth2/bar/foo", (Object)"b3", "CamelFileName", (Object)"b3.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testMin1Max1() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"a", "b"});
        this.template.sendBodyAndHeader("file:target/depth3", (Object)"a", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader("file:target/depth3", (Object)"b", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader("file:target/depth3/foo", (Object)"a2", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader("file:target/depth3/foo/bar", (Object)"a3", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader("file:target/depth3/bar", (Object)"b2", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader("file:target/depth3/bar/foo", (Object)"b3", "CamelFileName", (Object)"b.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file:target/depth?recursive=true&minDepth=2&maxDepth=2").convertBodyTo(String.class)).to("mock:result");
                ((RouteDefinition)this.from("file:target/depth2?recursive=true&minDepth=2&maxDepth=99").convertBodyTo(String.class)).to("mock:result");
                ((RouteDefinition)this.from("file:target/depth3?recursive=true&minDepth=1&maxDepth=1").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

