/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Date;
import java.util.Set;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileProducerDirectoryChmodOptionTest
extends ContextTestSupport {
    public static final String TEST_DIRECTORY = "target/chmoddir/foo/";

    @Override
    protected void setUp() throws Exception {
        FileProducerDirectoryChmodOptionTest.deleteDirectory(TEST_DIRECTORY);
        super.setUp();
    }

    private boolean canTest() {
        return !FileProducerDirectoryChmodOptionTest.isPlatform("windows");
    }

    public void testWriteValidNoDir() throws Exception {
        if (!this.canTest()) {
            return;
        }
        this.runChmodCheck("NoDir", null, "rwxr-xr-x");
    }

    public void testWriteValidChmod0755() throws Exception {
        if (!this.canTest()) {
            return;
        }
        this.runChmodCheck("0755", "rwxrwxrwx", "rwxr-xr-x");
    }

    public void testWriteValidChmod666() throws Exception {
        if (!this.canTest()) {
            return;
        }
        this.runChmodCheck("666", "rwxrwxrwx", "rw-rw-rw-");
    }

    private void runChmodCheck(String routeSuffix, String expectedDirectoryPermissions, String expectedPermissions) throws Exception {
        Set<PosixFilePermission> permissions;
        MockEndpoint mock = this.getMockEndpoint("mock:chmod" + routeSuffix);
        mock.expectedMessageCount(1);
        String testFileName = "chmod" + routeSuffix + ".txt";
        String fullTestFileName = TEST_DIRECTORY + testFileName;
        String testFileContent = "Writing file with chmod " + routeSuffix + " option at " + new Date();
        mock.expectedFileExists(fullTestFileName, testFileContent);
        this.template.sendBodyAndHeader("direct:write" + routeSuffix, (Object)testFileContent, "CamelFileName", (Object)testFileName);
        if (expectedDirectoryPermissions != null) {
            File d = new File(TEST_DIRECTORY);
            permissions = Files.getPosixFilePermissions(d.toPath(), LinkOption.NOFOLLOW_LINKS);
            FileProducerDirectoryChmodOptionTest.assertEquals((String)expectedDirectoryPermissions, (String)PosixFilePermissions.toString(permissions));
            FileProducerDirectoryChmodOptionTest.assertEquals((int)expectedDirectoryPermissions.replace("-", "").length(), (int)permissions.size());
        }
        if (expectedPermissions != null) {
            File f = new File(fullTestFileName);
            permissions = Files.getPosixFilePermissions(f.toPath(), LinkOption.NOFOLLOW_LINKS);
            FileProducerDirectoryChmodOptionTest.assertEquals((String)expectedPermissions, (String)PosixFilePermissions.toString(permissions));
            FileProducerDirectoryChmodOptionTest.assertEquals((int)expectedPermissions.replace("-", "").length(), (int)permissions.size());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:write666").to("file://target/chmoddir/foo/?chmodDirectory=777&chmod=666")).to("mock:chmod666");
                ((RouteDefinition)this.from("direct:write0755").to("file://target/chmoddir/foo/?chmodDirectory=777&chmod=0755")).to("mock:chmod0755");
                ((RouteDefinition)this.from("direct:writeNoDir").to("file://target/chmoddir/foo/?chmod=0755")).to("mock:chmodNoDir");
            }
        };
    }
}

