/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Date;
import java.util.Set;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileProducerChmodOptionTest
extends ContextTestSupport {
    public static final String TEST_DIRECTORY = "target/fileProducerChmodOptionTest/";

    @Override
    protected void setUp() throws Exception {
        FileProducerChmodOptionTest.deleteDirectory(TEST_DIRECTORY);
        super.setUp();
    }

    private boolean canTest() {
        return !FileProducerChmodOptionTest.isPlatform("windows");
    }

    public void testWriteValidChmod0755() throws Exception {
        if (!this.canTest()) {
            return;
        }
        this.runChmodCheck("0755", "rwxr-xr-x");
    }

    public void testWriteValidChmod666() throws Exception {
        if (!this.canTest()) {
            return;
        }
        this.runChmodCheck("666", "rw-rw-rw-");
    }

    private void runChmodCheck(String routeSuffix, String expectedPermissions) throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:chmod" + routeSuffix);
        mock.expectedMessageCount(1);
        String testFileName = "chmod" + routeSuffix + ".txt";
        String fullTestFileName = TEST_DIRECTORY + testFileName;
        String testFileContent = "Writing file with chmod " + routeSuffix + " option at " + new Date();
        mock.expectedFileExists(fullTestFileName, testFileContent);
        this.template.sendBodyAndHeader("direct:write" + routeSuffix, (Object)testFileContent, "CamelFileName", (Object)testFileName);
        File f = new File(fullTestFileName);
        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(f.toPath(), LinkOption.NOFOLLOW_LINKS);
        FileProducerChmodOptionTest.assertEquals((String)expectedPermissions, (String)PosixFilePermissions.toString(permissions));
        FileProducerChmodOptionTest.assertEquals((int)expectedPermissions.replace("-", "").length(), (int)permissions.size());
        this.assertMockEndpointsSatisfied();
    }

    public void testInvalidChmod() throws Exception {
        if (!this.canTest()) {
            return;
        }
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((RouteDefinition)this.from("direct:writeBadChmod1").to("file://target/fileProducerChmodOptionTest/?chmod=abc")).to("mock:badChmod1");
                }
            });
            FileProducerChmodOptionTest.fail((String)"Expected FailedToCreateRouteException");
        }
        catch (Exception e) {
            FileProducerChmodOptionTest.assertTrue((String)("Expected FailedToCreateRouteException, was " + e.getClass().getCanonicalName()), (boolean)(e instanceof FailedToCreateRouteException));
            FileProducerChmodOptionTest.assertTrue((String)("Message was [" + e.getMessage() + "]"), (boolean)e.getMessage().endsWith("conversion possible: chmod option [abc] is not valid"));
        }
    }

    public void testWriteNoChmod() throws Exception {
        if (!this.canTest()) {
            return;
        }
        MockEndpoint mock = this.getMockEndpoint("mock:noChmod");
        mock.expectedMessageCount(1);
        String testFileName = "noChmod.txt";
        String fullTestFileName = TEST_DIRECTORY + testFileName;
        String testFileContent = "Writing file with no chmod option at " + new Date();
        mock.expectedFileExists(fullTestFileName, testFileContent);
        this.template.sendBodyAndHeader("direct:writeNoChmod", (Object)testFileContent, "CamelFileName", (Object)testFileName);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:write666").to("file://target/fileProducerChmodOptionTest/?chmod=666")).to("mock:chmod666");
                ((RouteDefinition)this.from("direct:write0755").to("file://target/fileProducerChmodOptionTest/?chmod=0755")).to("mock:chmod0755");
                ((RouteDefinition)this.from("direct:writeNoChmod").to("file://target/fileProducerChmodOptionTest/")).to("mock:noChmod");
            }
        };
    }
}

