/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class FileProduceOverruleTest
extends ContextTestSupport {
    public void testNoOverrule() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("CamelFileName", (Object)"hello.txt");
        mock.expectedFileExists("target/write/hello.txt", "Hello World");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testOnlyOverrule() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).header("CamelFileName")).isNull();
        mock.expectedFileExists("target/write/overrule.txt", "Hello World");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "CamelOverruleFileName", (Object)"overrule.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testBoth() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("CamelFileName", (Object)"hello.txt");
        ((ValueBuilder)mock.message(0).header("CamelOverruleFileName")).isNull();
        mock.expectedFileExists("target/write/ruled.txt", "Hello World");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("CamelFileName", "hello.txt");
        map.put("CamelOverruleFileName", "ruled.txt");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", map);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        FileProduceOverruleTest.deleteDirectory("target/write");
        super.setUp();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to(new String[]{"file://target/write", "mock:result"});
            }
        };
    }
}

