/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileNoOpLockFileTest
extends ContextTestSupport {
    @Override
    protected void tearDown() throws Exception {
        FileNoOpLockFileTest.deleteDirectory("target/reports");
        super.tearDown();
    }

    public void testLocked() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedBodiesReceived(new Object[]{"Hello Locked"});
        this.template.sendBodyAndHeader("file:target/reports/locked", (Object)"Hello Locked", "CamelFileName", (Object)"report.txt");
        mock.assertIsSatisfied();
        Thread.sleep(200L);
        FileNoOpLockFileTest.checkLockFile(false);
    }

    public void testNotLocked() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedBodiesReceived(new Object[]{"Hello Not Locked"});
        this.template.sendBodyAndHeader("file:target/reports/notlocked", (Object)"Hello Not Locked", "CamelFileName", (Object)"report.txt");
        mock.assertIsSatisfied();
        Thread.sleep(200L);
        FileNoOpLockFileTest.checkLockFile(false);
    }

    private static void checkLockFile(boolean expected) {
        String filename = "target/reports/";
        filename = filename + (expected ? "locked/" : "notlocked/");
        filename = filename + "report.txt.camelLock";
        File file = new File(filename);
        FileNoOpLockFileTest.assertEquals((String)("Lock file should " + (expected ? "exists" : "not exists")), (boolean)expected, (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/reports/locked/?noop=true").process((Processor)new MyNoopProcessor())).to("mock:report");
                ((RouteDefinition)this.from("file://target/reports/notlocked/?noop=true&readLock=none").process((Processor)new MyNoopProcessor())).to("mock:report");
            }
        };
    }

    private static class MyNoopProcessor
    implements Processor {
        private MyNoopProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            boolean locked = "Hello Locked".equals(body);
            FileNoOpLockFileTest.checkLockFile(locked);
        }
    }
}

