/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class FileMarkerFileRecursiveFilterDeleteOldLockFilesTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myFilter", (Object)new MyFileFilter());
        return jndi;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        FileMarkerFileRecursiveFilterDeleteOldLockFilesTest.deleteDirectory("target/oldlock");
        this.template.sendBodyAndHeader("file:target/oldlock", (Object)"locked", "CamelFileName", (Object)"hello.txt.camelLock");
        this.template.sendBodyAndHeader("file:target/oldlock", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader("file:target/oldlock/foo", (Object)"locked", "CamelFileName", (Object)"gooday.txt.camelLock");
        this.template.sendBodyAndHeader("file:target/oldlock/foo", (Object)"Hi World", "CamelFileName", (Object)"hi.txt");
        this.template.sendBodyAndHeader("file:target/oldlock/bar", (Object)"locked", "CamelFileName", (Object)"davs.txt.camelLock");
        this.template.sendBodyAndHeader("file:target/oldlock/bar", (Object)"Davs World", "CamelFileName", (Object)"davs.txt");
    }

    public void testDeleteOldLockOnStartup() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedBodiesReceived(new Object[]{"Bye World", "Hi World"});
        ((ValueBuilder)mock.message(0).header("CamelFileNameOnly")).isEqualTo((Object)"bye.txt");
        ((ValueBuilder)mock.message(1).header("CamelFileNameOnly")).isEqualTo((Object)"hi.txt");
        mock.expectedFileExists("target/oldlock/bar/davs.txt");
        mock.expectedFileExists("target/oldlock/bar/davs.txt.camelLock");
        this.context.startRoute("foo");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file:target/oldlock?recursive=true&sortBy=file:name&filter=#myFilter").routeId("foo").noAutoStartup().convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    private static final class MyFileFilter
    implements GenericFileFilter<File> {
        private MyFileFilter() {
        }

        public boolean accept(GenericFile<File> file) {
            return !file.isDirectory() || !"bar".equals(file.getFileName());
        }
    }
}

