/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileMarkerFileDeleteOldLockFilesTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        FileMarkerFileDeleteOldLockFilesTest.deleteDirectory("target/oldlock");
        this.template.sendBodyAndHeader("file:target/oldlock", (Object)"locked", "CamelFileName", (Object)"hello.txt.camelLock");
        this.template.sendBodyAndHeader("file:target/oldlock", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
    }

    public void testDeleteOldLockOnStartup() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        ((ValueBuilder)mock.message(0).header("CamelFileName")).isEqualTo((Object)"bye.txt");
        this.context.startRoute("foo");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file:target/oldlock").routeId("foo").noAutoStartup().convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

