/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerIncludeAndExcludeNameTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerIncludeAndExcludeNameTest.deleteDirectory("target/includeexclude");
        super.setUp();
    }

    public void testIncludePreAndPostfixes() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Report 2", "Report 3", "Report 4"});
        mock.expectedMessageCount(3);
        this.sendFiles();
        mock.assertIsSatisfied();
    }

    private void sendFiles() throws Exception {
        String url = "file://target/includeexclude";
        this.template.sendBodyAndHeader(url, (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader(url, (Object)"Report 1", "CamelFileName", (Object)"report1.xml");
        this.template.sendBodyAndHeader(url, (Object)"Report 2", "CamelFileName", (Object)"report2.txt");
        this.template.sendBodyAndHeader(url, (Object)"Report 3", "CamelFileName", (Object)"report3.txt");
        this.template.sendBodyAndHeader(url, (Object)"Report 4", "CamelFileName", (Object)"Report4.txt");
        this.template.sendBodyAndHeader(url, (Object)"Secret", "CamelFileName", (Object)"Secret.txt");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/includeexclude/?include=report.*txt&exclude=hello.*").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

