/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumeSimpleRelativeMoveToRelativeTest
extends ContextTestSupport {
    private String fileUrl = "file://target/move";

    @Override
    protected void setUp() throws Exception {
        FileConsumeSimpleRelativeMoveToRelativeTest.deleteDirectory("target/move");
        super.setUp();
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"Hello World", "CamelFileName", (Object)"sub/hello.txt");
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"Goodday World", "CamelFileName", (Object)"sub/sub2/goodday.txt");
    }

    public void testMoveToSubDir() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        mock.expectedFileExists("target/move/.done/bye.txt");
        mock.expectedFileExists("target/move/sub/.done/hello.txt");
        mock.expectedFileExists("target/move/sub/sub2/.done/goodday.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/move?recursive=true&move=.done").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

