/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.FileUtil;

public class FileConsumePollEnrichFileUsingProcessorTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumePollEnrichFileUsingProcessorTest.deleteDirectory("target/enrich");
        FileConsumePollEnrichFileUsingProcessorTest.deleteDirectory("target/enrichdata");
        super.setUp();
    }

    public void testPollEnrich() throws Exception {
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Start"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Big file"});
        mock.expectedFileExists("target/enrich/.done/AAA.fin");
        mock.expectedFileExists("target/enrichdata/.done/AAA.dat");
        mock.expectedFileExists("target/enrichdata/BBB.dat");
        this.template.sendBodyAndHeader("file://target/enrichdata", (Object)"Big file", "CamelFileName", (Object)"AAA.dat");
        this.template.sendBodyAndHeader("file://target/enrichdata", (Object)"Other Big file", "CamelFileName", (Object)"BBB.dat");
        this.template.sendBodyAndHeader("file://target/enrich", (Object)"Start", "CamelFileName", (Object)"AAA.fin");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/enrich?move=.done").process(new Processor(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void process(Exchange exchange) throws Exception {
                        String name = (String)exchange.getIn().getHeader("CamelFileNameOnly", String.class);
                        name = FileUtil.stripExt((String)name) + ".dat";
                        Exchange data = null;
                        ConsumerTemplate con = exchange.getContext().createConsumerTemplate();
                        try {
                            data = con.receive("file://target/enrichdata?move=.done&fileName=" + name, 5000L);
                        }
                        finally {
                            con.stop();
                        }
                        if (data == null) {
                            throw new CamelExchangeException("Cannot find the data file " + name, exchange);
                        }
                        FileConsumePollEnrichFileUsingProcessorTest.this.template.send("direct:data", data);
                    }
                })).to("mock:start");
                this.from("direct:data").to("mock:result");
            }
        };
    }
}

