/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.directvm.AbstractDirectVmTestSupport;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;

public class DirectVmTwoCamelContextDuplicateConsumerTest
extends AbstractDirectVmTestSupport {
    public void testThirdClash() throws Exception {
        DefaultCamelContext third = new DefaultCamelContext();
        third.addRoutes((RoutesBuilder)this.createRouteBuilderForThirdContext());
        try {
            third.start();
            DirectVmTwoCamelContextDuplicateConsumerTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalStateException e) {
            DirectVmTwoCamelContextDuplicateConsumerTest.assertEquals((String)"A consumer Consumer[direct-vm://foo] already exists from CamelContext: camel-1. Multiple consumers not supported", (String)e.getMessage());
        }
        this.context.stop();
        third.start();
        MockEndpoint mock = (MockEndpoint)third.getEndpoint("mock:third", MockEndpoint.class);
        mock.expectedMessageCount(1);
        this.template2.sendBody("direct:start", (Object)"Hello World");
        mock.assertIsSatisfied();
        third.stop();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct-vm:foo").transform((Expression)this.constant("Bye World"))).log("Running on Camel ${camelId} on thread ${threadName} with message ${body}")).to("mock:result");
            }
        };
    }

    @Override
    protected RouteBuilder createRouteBuilderForSecondContext() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").log("Running on Camel ${camelId} on thread ${threadName} with message ${body}")).to("direct-vm:foo");
            }
        };
    }

    protected RouteBuilder createRouteBuilderForThirdContext() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct-vm:foo").transform((Expression)this.constant("Bye World"))).log("Running on Camel ${camelId} on thread ${threadName} with message ${body}")).to("mock:third");
            }
        };
    }
}

