/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.directvm.DirectVmComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class DirectVmComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        DirectVmComponent comp = (DirectVmComponent)this.context.getComponent("direct-vm", DirectVmComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("direct-vm:foo?block=false");
        DirectVmComponentConfigurationAndDocumentationTest.assertEquals((Object)"false", (Object)conf.getParameter("block"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        DirectVmComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        DirectVmComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"name\": { \"kind\": \"path\", \"group\": \"common\", \"required\": \"true\", \"type\": \"string\""));
        DirectVmComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"timeout\": { \"kind\": \"parameter\", \"group\": \"producer\", \"label\": \"producer\", \"type\": \"integer\""));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("direct-vm");
        DirectVmComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML", (Object)html);
    }
}

