/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import junit.framework.TestCase;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;

public class TwoCamelContextDirectEndpointTest
extends TestCase {
    private DefaultCamelContext camel1;
    private DefaultCamelContext camel2;

    protected void setUp() throws Exception {
        super.setUp();
        this.camel1 = new DefaultCamelContext();
        this.camel1.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("direct:foo");
                this.from("direct:foo").to("mock:a");
            }
        });
        this.camel1.start();
        this.camel2 = new DefaultCamelContext();
        this.camel2.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("direct:foo");
                this.from("direct:foo").to("mock:b");
            }
        });
        this.camel2.start();
    }

    protected void tearDown() throws Exception {
        this.camel1.stop();
        this.camel2.stop();
        super.tearDown();
    }

    public void testTwoCamelContextDirectEndpoint() throws Exception {
        Endpoint start1 = this.camel1.getEndpoint("direct:start");
        Endpoint start2 = this.camel2.getEndpoint("direct:start");
        TwoCamelContextDirectEndpointTest.assertNotSame((Object)start1, (Object)start2);
        Endpoint foo1 = this.camel1.getEndpoint("direct:foo");
        Endpoint foo2 = this.camel2.getEndpoint("direct:foo");
        TwoCamelContextDirectEndpointTest.assertNotSame((Object)foo1, (Object)foo2);
        MockEndpoint mock1 = (MockEndpoint)this.camel1.getEndpoint("mock:a", MockEndpoint.class);
        mock1.expectedBodiesReceived(new Object[]{"Hello World"});
        MockEndpoint mock2 = (MockEndpoint)this.camel2.getEndpoint("mock:b", MockEndpoint.class);
        mock2.expectedBodiesReceived(new Object[]{"Bye World"});
        this.camel1.createProducerTemplate().sendBody("direct:start", (Object)"Hello World");
        this.camel2.createProducerTemplate().sendBody("direct:start", (Object)"Bye World");
        mock1.assertIsSatisfied();
        mock2.assertIsSatisfied();
    }
}

