/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.FileDataSet;

public class FileDataSetProducerWithSplitTest
extends ContextTestSupport {
    protected FileDataSet dataSet;
    final String testDataFileName = "src/test/data/file-dataset-test.txt";
    final int testDataFileRecordCount = 10;
    final String sourceUri = "direct://source";
    final String dataSetName = "foo";
    final String dataSetUri = "dataset://foo";

    public void testDefaultListDataSet() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.template.sendBodyAndHeader("direct://source", (Object)("Line " + (1 + i)), "CamelDataSetIndex", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testDefaultListDataSetWithSizeGreaterThanListSize() throws Exception {
        int messageCount = 20;
        this.dataSet.setSize((long)messageCount);
        this.getMockEndpoint("dataset://foo").expectedMessageCount(messageCount);
        for (int i = 0; i < messageCount; ++i) {
            this.template.sendBodyAndHeader("direct://source", (Object)("Line " + (1 + i % 10)), "CamelDataSetIndex", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    public void setUp() throws Exception {
        this.dataSet = new FileDataSet("src/test/data/file-dataset-test.txt", System.lineSeparator());
        FileDataSetProducerWithSplitTest.assertEquals((String)"Unexpected DataSet size", (long)10L, (long)this.dataSet.getSize());
        super.setUp();
    }

    @Override
    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        context.bind("foo", (Object)this.dataSet);
        return context;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct://source").to("dataset://foo");
            }
        };
    }
}

