/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.dataset.SimpleDataSet;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class DataSetProducerTest
extends ContextTestSupport {
    protected SimpleDataSet dataSet = new SimpleDataSet(20);
    final String dataSetName = "foo";
    final String dataSetUri = "dataset://foo";
    final String dataSetUriWithDataSetIndexSetToOff = "dataset://foo?dataSetIndex=off";
    final String dataSetUriWithDataSetIndexSetToLenient = "dataset://foo?dataSetIndex=lenient";
    final String dataSetUriWithDataSetIndexSetToStrict = "dataset://foo?dataSetIndex=strict";
    final String sourceUri = "direct://source";
    final String resultUri = "mock://result";

    @Override
    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        context.bind("foo", (Object)this.dataSet);
        return context;
    }

    @Test
    public void testSendingMessagesExplicitlyToDataSetEndpointWithDataSetIndexHeader() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            this.template.sendBodyAndHeader("dataset://foo", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendingMessagesExplicitlyToDataSetEndpointWithoutDataSetIndexHeader() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            this.template.sendBody("dataset://foo", this.dataSet.getDefaultBody());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendingMessagesExplicitlyToDataSetEndpointWithoutDataSetIndexAndDataSetIndexUriParameterSetToOff() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            if (0L == i % 2L) {
                this.template.sendBodyAndHeader("dataset://foo?dataSetIndex=lenient", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
                continue;
            }
            this.template.sendBody("dataset://foo?dataSetIndex=lenient", this.dataSet.getDefaultBody());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendingMessagesExplicitlyToDataSetEndpointWithoutDataSetIndexAndDataSetIndexUriParameterSetToLenient() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            if (0L == i % 2L) {
                this.template.sendBodyAndHeader("dataset://foo?dataSetIndex=lenient", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
                continue;
            }
            this.template.sendBody("dataset://foo?dataSetIndex=lenient", this.dataSet.getDefaultBody());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendingMessagesExplicitlyToDataSetEndpointWithoutDataSetIndexAndDataSetIndexUriParameterSetToStrict() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            this.template.sendBodyAndHeader("dataset://foo?dataSetIndex=strict", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNotSettingDataSetIndexHeaderWhenDataSetIndexUriParameterIsUnset() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            if (0L == size % 2L) {
                this.template.sendBodyAndHeader("dataset://foo", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
                continue;
            }
            this.template.sendBody("dataset://foo", this.dataSet.getDefaultBody());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNotSettingDataSetIndexHeaderWhenDataSetIndexUriParameterSetToOff() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            if (0L == size % 2L) {
                this.template.sendBodyAndHeader("dataset://foo?dataSetIndex=off", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)(size - i));
                continue;
            }
            this.template.sendBody("dataset://foo?dataSetIndex=off", this.dataSet.getDefaultBody());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNotSettingDataSetIndexHeaderWhenDataSetIndexUriParameterSetToLenient() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            if (0L == size % 2L) {
                this.template.sendBodyAndHeader("dataset://foo?dataSetIndex=lenient", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
                continue;
            }
            this.template.sendBody("dataset://foo?dataSetIndex=lenient", this.dataSet.getDefaultBody());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNotSettingDataSetIndexHeaderWhenDataSetIndexUriParameterSetToStrict() throws Exception {
        long size = this.dataSet.getSize();
        for (long i = 0L; i < size; ++i) {
            this.template.sendBody("dataset://foo?dataSetIndex=strict", this.dataSet.getDefaultBody());
        }
        try {
            this.assertMockEndpointsSatisfied();
        }
        catch (AssertionError assertionError) {
            String expectedErrorString = "dataset://foo?dataSetIndex=strict Failed due to caught exception: " + NoSuchHeaderException.class.getName() + ": No '" + "CamelDataSetIndex" + "' header available of type: java.lang.Long. Exchange";
            String actualErrorString = ((Throwable)((Object)assertionError)).getMessage();
            if (actualErrorString.startsWith(expectedErrorString)) {
                return;
            }
            throw assertionError;
        }
        DataSetProducerTest.fail((String)"AssertionError should have been generated");
    }

    @Test
    public void testDataSetIndexUriParameterUnset() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct://source").to("dataset://foo")).to("mock://result");
            }
        });
        this.context.start();
        long size = this.dataSet.getSize();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)size);
        ((ValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        result.expectsAscending((Expression)DataSetProducerTest.header("CamelDataSetIndex").convertTo(Number.class));
        for (long i = 0L; i < size; ++i) {
            this.template.sendBody("direct://source", this.dataSet.getDefaultBody());
        }
        this.assertMockEndpointsSatisfied();
        result.assertMessagesAscending((Expression)DataSetProducerTest.header("CamelDataSetIndex").convertTo(Number.class));
    }

    @Test
    public void testDataSetIndexUriParameterSetToOff() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct://source").to("dataset://foo?dataSetIndex=off")).to("mock://result");
            }
        });
        this.context.start();
        long size = this.dataSet.getSize();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)size);
        result.expectsAscending((Expression)DataSetProducerTest.header("CamelDataSetIndex").convertTo(Number.class));
        ((ValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        for (long i = 0L; i < size; ++i) {
            this.template.sendBodyAndHeader("direct://source", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDataSetIndexUriParameterSetToLenient() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct://source").to("dataset://foo?dataSetIndex=lenient")).to("mock://result");
            }
        });
        this.context.start();
        long size = this.dataSet.getSize();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)size);
        result.expectsAscending((Expression)DataSetProducerTest.header("CamelDataSetIndex").convertTo(Number.class));
        ((ValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        for (long i = 0L; i < size; ++i) {
            this.template.sendBodyAndHeader("direct://source", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDataSetIndexUriParameterSetToStrict() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct://source").to("dataset://foo?dataSetIndex=strict")).to("mock://result");
            }
        });
        this.context.start();
        long size = this.dataSet.getSize();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)size);
        result.expectsAscending((Expression)DataSetProducerTest.header("CamelDataSetIndex").convertTo(Number.class));
        ((ValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        for (long i = 0L; i < size; ++i) {
            this.template.sendBodyAndHeader("direct://source", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInvalidDataSetIndexValueWithDataSetIndexUriParameterUnset() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct://source").to("dataset://foo")).to("mock://result");
            }
        });
        this.context.start();
        long size = this.dataSet.getSize();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)size);
        ((ValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        for (long i = 0L; i < size; ++i) {
            if (i == size / 2L) {
                this.template.sendBodyAndHeader("direct://source", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)(i + 10L));
                continue;
            }
            this.template.sendBody("direct://source", this.dataSet.getDefaultBody());
        }
        try {
            this.assertMockEndpointsSatisfied();
        }
        catch (AssertionError assertionError) {
            String expectedErrorString = "dataset://foo Failed due to caught exception: " + AssertionError.class.getName() + ": Header: " + "CamelDataSetIndex" + " does not match. Expected: " + size / 2L + " but was: " + (size / 2L + 10L) + " on Exchange";
            String actualErrorString = ((Throwable)((Object)assertionError)).getMessage();
            if (actualErrorString.startsWith(expectedErrorString)) {
                return;
            }
            throw assertionError;
        }
        DataSetProducerTest.fail((String)"AssertionError should have been generated");
    }

    @Test
    public void testInvalidDataSetIndexValueWithDataSetIndexUriParameterSetToOff() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct://source").to("dataset://foo?dataSetIndex=off")).to("mock://result");
            }
        });
        this.context.start();
        long size = this.dataSet.getSize();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)size);
        for (long i = 0L; i < size; ++i) {
            if (i == size / 2L) {
                this.template.sendBodyAndHeader("direct://source", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)(i + 10L));
                continue;
            }
            this.template.sendBody("direct://source", this.dataSet.getDefaultBody());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInvalidDataSetIndexValueWithDataSetIndexUriParameterSetToLenient() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct://source").to("dataset://foo?dataSetIndex=lenient")).to("mock://result");
            }
        });
        this.context.start();
        long size = this.dataSet.getSize();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)size);
        ((ValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        for (long i = 0L; i < size; ++i) {
            if (i == size / 2L) {
                this.template.sendBodyAndHeader("direct://source", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)(i + 10L));
                continue;
            }
            this.template.sendBody("direct://source", this.dataSet.getDefaultBody());
        }
        try {
            this.assertMockEndpointsSatisfied();
        }
        catch (AssertionError assertionError) {
            String expectedErrorString = "dataset://foo?dataSetIndex=lenient Failed due to caught exception: " + AssertionError.class.getName() + ": Header: " + "CamelDataSetIndex" + " does not match. Expected: " + size / 2L + " but was: " + (size / 2L + 10L) + " on Exchange";
            String actualErrorString = ((Throwable)((Object)assertionError)).getMessage();
            if (actualErrorString.startsWith(expectedErrorString)) {
                return;
            }
            throw assertionError;
        }
        DataSetProducerTest.fail((String)"AssertionError should have been generated");
    }

    @Test
    public void testInvalidDataSetIndexValueWithDataSetIndexUriParameterSetToStrict() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct://source").to("dataset://foo?dataSetIndex=strict")).to("mock://result");
            }
        });
        this.context.start();
        long size = this.dataSet.getSize();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)size);
        ((ValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        for (long i = 0L; i < size; ++i) {
            if (i == size / 2L) {
                this.template.sendBodyAndHeader("direct://source", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)(i + 10L));
                continue;
            }
            this.template.sendBodyAndHeader("direct://source", this.dataSet.getDefaultBody(), "CamelDataSetIndex", (Object)i);
        }
        try {
            this.assertMockEndpointsSatisfied();
        }
        catch (AssertionError assertionError) {
            String expectedErrorString = "dataset://foo?dataSetIndex=strict Failed due to caught exception: " + AssertionError.class.getName() + ": Header: " + "CamelDataSetIndex" + " does not match. Expected: " + size / 2L + " but was: " + (size / 2L + 10L) + " on Exchange";
            String actualErrorString = ((Throwable)((Object)assertionError)).getMessage();
            if (actualErrorString.startsWith(expectedErrorString)) {
                return;
            }
            throw assertionError;
        }
        DataSetProducerTest.fail((String)"AssertionError should have been generated");
    }
}

