/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.dataset.SimpleDataSet;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class DataSetConsumerTest
extends ContextTestSupport {
    protected SimpleDataSet dataSet = new SimpleDataSet(5);
    final String dataSetName = "foo";
    final String dataSetUri = "dataset://foo";
    final String dataSetUriWithDataSetIndexSetToOff = "dataset://foo?dataSetIndex=off";
    final String dataSetUriWithDataSetIndexSetToLenient = "dataset://foo?dataSetIndex=lenient";
    final String dataSetUriWithDataSetIndexSetToStrict = "dataset://foo?dataSetIndex=strict";
    final String resultUri = "mock://result";

    @Override
    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        context.bind("foo", (Object)this.dataSet);
        return context;
    }

    @Test
    public void testConsumerOnlyEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("dataset://foo").to("mock://result");
            }
        });
        this.context.start();
        DataSetConsumerTest.assertEquals((String)"expectedMessageCount should be unset(i.e. -1) for a consumer-only endpoint", (int)-1, (int)this.getMockEndpoint("dataset://foo").getExpectedCount());
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)this.dataSet.getSize());
        result.assertMessagesAscending((Expression)DataSetConsumerTest.header("CamelDataSetIndex"));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConsumerWithProducer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("dataset://foo").to("dataset://foo")).to("mock://result");
            }
        });
        this.context.start();
        DataSetConsumerTest.assertEquals((String)"expectedMessageCount should be the same as the DataSet size for a consumer-producer endpoint", (long)this.dataSet.getSize(), (long)this.getMockEndpoint("dataset://foo").getExpectedCount());
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)this.dataSet.getSize());
        result.expectsAscending((Expression)DataSetConsumerTest.header("CamelDataSetIndex").convertTo(Number.class));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testWithDataSetIndexUriParameterUnset() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("dataset://foo").to("mock://result");
            }
        });
        this.context.start();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)this.dataSet.getSize());
        ((ValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        result.expectsAscending((Expression)DataSetConsumerTest.header("CamelDataSetIndex").convertTo(Number.class));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testWithDataSetIndexUriParameterSetToOff() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("dataset://foo?dataSetIndex=off").to("mock://result");
            }
        });
        this.context.start();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)this.dataSet.getSize());
        ((ValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNull();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testWithDataSetIndexUriParameterSetToLenient() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("dataset://foo?dataSetIndex=lenient").to("mock://result");
            }
        });
        this.context.start();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)this.dataSet.getSize());
        ((ValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        result.expectsAscending((Expression)DataSetConsumerTest.header("CamelDataSetIndex").convertTo(Number.class));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testWithDataSetIndexUriParameterSetToStrict() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("dataset://foo?dataSetIndex=strict").to("mock://result");
            }
        });
        this.context.start();
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMessageCount((int)this.dataSet.getSize());
        ((ValueBuilder)result.allMessages().header("CamelDataSetIndex")).isNotNull();
        result.expectsAscending((Expression)DataSetConsumerTest.header("CamelDataSetIndex").convertTo(Number.class));
        Thread.sleep(100L);
        this.assertMockEndpointsSatisfied();
        System.out.println("Place for Breakpoint");
    }
}

