/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.dataset.DataSetComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class DataSetComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        DataSetComponent comp = (DataSetComponent)this.context.getComponent("dataset", DataSetComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("dataset:foo?minRate=3&produceDelay=33&consumeDelay=333&preloadSize=3333&initialDelay=33333&disableDataSetIndex=true");
        DataSetComponentConfigurationAndDocumentationTest.assertEquals((String)"Unexpected endpoint configuration value for minRate", (Object)"3", (Object)conf.getParameter("minRate"));
        DataSetComponentConfigurationAndDocumentationTest.assertEquals((String)"Unexpected endpoint configuration value for produceDelay", (Object)"33", (Object)conf.getParameter("produceDelay"));
        DataSetComponentConfigurationAndDocumentationTest.assertEquals((String)"Unexpected endpoint configuration value for consumeDelay", (Object)"333", (Object)conf.getParameter("consumeDelay"));
        DataSetComponentConfigurationAndDocumentationTest.assertEquals((String)"Unexpected endpoint configuration value for preloadSize", (Object)"3333", (Object)conf.getParameter("preloadSize"));
        DataSetComponentConfigurationAndDocumentationTest.assertEquals((String)"Unexpected endpoint configuration value for initialDelay", (Object)"33333", (Object)conf.getParameter("initialDelay"));
        DataSetComponentConfigurationAndDocumentationTest.assertEquals((String)"Unexpected endpoint configuration value for disableDataSetIndex", (Object)"true", (Object)conf.getParameter("disableDataSetIndex"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        DataSetComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        DataSetComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"name\": { \"kind\": \"path\", \"group\": \"common\", \"required\": \"true\", \"type\""));
        DataSetComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"kind\": \"parameter\", \"group\": \"consumer\", \"label\": \"consumer\", \"type\": \"integer\""));
        DataSetComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"retainFirst\": { \"kind\": \"parameter\", \"group\": \"producer\", \"label\": \"producer\", \"type\": \"integer"));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("dataset");
        DataSetComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML", (Object)html);
    }
}

