/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.controlbus;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class ControlBusStartRouteTest
extends ContextTestSupport {
    public void testControlBusStartStop() throws Exception {
        ControlBusStartRouteTest.assertEquals((String)"Stopped", (String)this.context.getRouteStatus("foo").name());
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.template.sendBody("controlbus:route?routeId=foo&action=start", null);
        this.assertMockEndpointsSatisfied();
        this.template.sendBody("controlbus:route?routeId=foo&action=stop", null);
        ControlBusStartRouteTest.assertEquals((String)"Stopped", (String)this.context.getRouteStatus("foo").name());
    }

    public void testControlBusSuspendResume() throws Exception {
        ControlBusStartRouteTest.assertEquals((String)"Stopped", (String)this.context.getRouteStatus("foo").name());
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.template.sendBody("controlbus:route?routeId=foo&action=start", null);
        this.assertMockEndpointsSatisfied();
        this.template.sendBody("controlbus:route?routeId=foo&action=suspend", null);
        ControlBusStartRouteTest.assertEquals((String)"Suspended", (String)this.context.getRouteStatus("foo").name());
        this.template.sendBody("controlbus:route?routeId=foo&action=resume", null);
        ControlBusStartRouteTest.assertEquals((String)"Started", (String)this.context.getRouteStatus("foo").name());
    }

    public void testControlBusStatus() throws Exception {
        ControlBusStartRouteTest.assertEquals((String)"Stopped", (String)this.context.getRouteStatus("foo").name());
        String status = (String)this.template.requestBody("controlbus:route?routeId=foo&action=status", null, String.class);
        ControlBusStartRouteTest.assertEquals((String)"Stopped", (String)status);
        this.context.startRoute("foo");
        status = (String)this.template.requestBody("controlbus:route?routeId=foo&action=status", null, String.class);
        ControlBusStartRouteTest.assertEquals((String)"Started", (String)status);
    }

    public void testControlBusCurrentRouteStatus() throws Exception {
        ControlBusStartRouteTest.assertTrue((boolean)this.context.getRouteStatus("current").isStarted());
        MockEndpoint mock = this.getMockEndpoint("mock:current");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{ServiceStatus.Started.name()});
        this.sendBody("seda:current", null);
        mock.assertIsSatisfied();
    }

    public void testControlBusStatusLevelWarn() throws Exception {
        ControlBusStartRouteTest.assertEquals((String)"Stopped", (String)this.context.getRouteStatus("foo").name());
        String status = (String)this.template.requestBody("controlbus:route?routeId=foo&action=status&loggingLevel=WARN", null, String.class);
        ControlBusStartRouteTest.assertEquals((String)"Stopped", (String)status);
        this.context.startRoute("foo");
        status = (String)this.template.requestBody("controlbus:route?routeId=foo&action=status&loggingLevel=WARN", null, String.class);
        ControlBusStartRouteTest.assertEquals((String)"Started", (String)status);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo").routeId("foo").noAutoStartup().to("mock:foo");
                ((RouteDefinition)this.from("seda:current").routeId("current").to("controlbus:route?routeId=current&action=status&loggingLevel=WARN")).to("mock:current");
            }
        };
    }
}

