/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TypeConverter;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.issues.DerivedClass;
import org.apache.camel.component.bean.issues.MyMessage;
import org.apache.camel.component.bean.issues.MyMessageListener;
import org.apache.camel.component.bean.issues.MyMessageToProcessorConverter;
import org.apache.camel.impl.JndiRegistry;

public class BeanRouteToDerivedClassTest
extends ContextTestSupport {
    private DerivedClass derived = new DerivedClass();

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testDerivedClassCalled() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("bean:derived?method=process");
            }
        });
        this.context.start();
        this.template.sendBody("direct:start", (Object)"Hello World");
        BeanRouteToDerivedClassTest.assertEquals((String)"Derived class should have been invoked", (String)"Hello World", (String)this.derived.getAndClearBody());
    }

    public void testDerivedClassCalledWithNoCustomProcessor() throws Exception {
        this.context.getTypeConverterRegistry().addTypeConverter(Processor.class, MyMessageListener.class, (TypeConverter)new MyMessageToProcessorConverter());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("bean:derived?method=process");
                this.from("direct:other").to("bean:derived");
            }
        });
        this.context.start();
        Object out = this.template.requestBody("direct:start", (Object)"Hello World");
        BeanRouteToDerivedClassTest.assertEquals((String)"Derived class should have been invoked", (String)"Hello World", (String)this.derived.getAndClearBody());
        BeanRouteToDerivedClassTest.assertEquals((String)"Hello World", (String)out.toString());
        out = this.template.requestBody("direct:other", (Object)new MyMessage("Hello World"));
        BeanRouteToDerivedClassTest.assertEquals((String)"Derived class should NOT have been invoked", null, (String)this.derived.getAndClearBody());
        BeanRouteToDerivedClassTest.assertEquals((String)"Bye World", (String)out.toString());
    }

    public void testDerivedClassCalledWithCustomProcessor() throws Exception {
        this.context.getTypeConverterRegistry().addTypeConverter(Processor.class, MyMessageListener.class, (TypeConverter)new MyMessageToProcessorConverter());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("bean:derived?method=process");
                this.from("direct:other").to("bean:derived");
            }
        });
        this.context.start();
        Object out = this.template.requestBody("direct:start", (Object)new MyMessage("Hello World"));
        BeanRouteToDerivedClassTest.assertEquals((String)"Derived class should have been invoked", (String)"Hello World", (String)this.derived.getAndClearBody());
        BeanRouteToDerivedClassTest.assertEquals((String)"Hello World", (String)out.toString());
        out = this.template.requestBody("direct:other", (Object)new MyMessage("Hello World"));
        BeanRouteToDerivedClassTest.assertEquals((String)"Derived class should NOT have been invoked", null, (String)this.derived.getAndClearBody());
        BeanRouteToDerivedClassTest.assertEquals((String)"Bye World", (String)out.toString());
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("derived", (Object)this.derived);
        return jndi;
    }
}

