/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Handler;
import org.apache.camel.language.XPath;
import org.apache.camel.util.jndi.JndiContext;

public class BeanWithXPathInjectionUsingHeaderValueTest
extends ContextTestSupport {
    protected MyBean myBean = new MyBean();

    public void testConstantXPathHeaders() throws Exception {
        this.template.sendBodyAndHeader("bean:myBean", (Object)"<response>OK</response>", "invoiceDetails", (Object)"<invoice><person><name>Alan</name><date>26/08/2012</date></person></invoice>");
        BeanWithXPathInjectionUsingHeaderValueTest.assertEquals((String)("bean response:  " + this.myBean), (String)"OK", (String)this.myBean.response);
        BeanWithXPathInjectionUsingHeaderValueTest.assertEquals((String)("bean userName: " + this.myBean), (String)"Alan", (String)this.myBean.userName);
        BeanWithXPathInjectionUsingHeaderValueTest.assertEquals((String)("bean date:  " + this.myBean), (String)"26/08/2012", (String)this.myBean.date);
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    public static class MyBean {
        public String userName;
        public String date;
        public String response;

        @Handler
        public void handler(@XPath(value="//response/text()") String response, @XPath(headerName="invoiceDetails", value="//invoice/person/name/text()") String userName, @XPath(headerName="invoiceDetails", value="//invoice/person/date", resultType=String.class) String date) {
            this.response = response;
            this.userName = userName;
            this.date = date;
        }
    }
}

