/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;

public class BeanPerformanceTest
extends ContextTestSupport {
    private static final AtomicLong INVOKED = new AtomicLong();
    private final int times = 100000;

    public static void doSomething(String payload) {
        BeanPerformanceTest.assertEquals((String)"Hello World", (String)payload);
        INVOKED.incrementAndGet();
    }

    public void testBeanPerformance() throws Exception {
        StopWatch watch = new StopWatch();
        this.log.info("Invoking a bean in a route {} times", (Object)100000);
        for (int i = 0; i < 100000; ++i) {
            this.template.sendBody("direct:start", (Object)"Hello World");
        }
        this.log.info("Took {} to invoke the bean {} times", (Object)TimeUtils.printDuration((double)watch.stop()), (Object)100000);
        BeanPerformanceTest.assertEquals((long)100000L, (long)INVOKED.get());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").bean(BeanPerformanceTest.class, "doSomething");
            }
        };
    }
}

