/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BeanParameterThreeBodyOgnlTest
extends ContextTestSupport {
    public void testBeanParameterValue() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"3"});
        ArrayList<String> body = new ArrayList<String>();
        body.add("A");
        body.add("B");
        body.add("C");
        this.template.sendBody("direct:start", body);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyBean());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("bean:foo?method=bar(${body[0]},${body[1]},${body[2]})")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public String bar(String order1, String order2, String order3) {
            TestCase.assertEquals((String)"A", (String)order1);
            TestCase.assertEquals((String)"B", (String)order2);
            TestCase.assertEquals((String)"C", (String)order3);
            return "3";
        }

        public String bar(String order1, String order2) {
            TestCase.assertEquals((String)"A", (String)order1);
            TestCase.assertEquals((String)"B", (String)order2);
            return "2";
        }

        public String bar(String order1) {
            TestCase.assertEquals((String)"A", (String)order1);
            return "1";
        }
    }
}

