/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class NotifyBuilderTest
extends ContextTestSupport {
    public void testMustBeCreated() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(1);
        try {
            notify.matches();
            NotifyBuilderTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalStateException e) {
            NotifyBuilderTest.assertEquals((String)"NotifyBuilder has not been created. Invoke the create() method before matching.", (String)e.getMessage());
        }
    }

    public void testDirectWhenExchangeDoneSimple() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenDone(1).create();
        NotifyBuilderTest.assertEquals((String)"from(direct:foo).whenDone(1)", (String)notify.toString());
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testDirectBeerWhenExchangeDoneSimple() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:beer").whenDone(1).create();
        NotifyBuilderTest.assertEquals((String)"from(direct:beer).whenDone(1)", (String)notify.toString());
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:beer", (Object)"A");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testDirectFromRoute() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).fromRoute("foo").whenDone(1).create();
        NotifyBuilderTest.assertEquals((String)"fromRoute(foo).whenDone(1)", (String)notify.toString());
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"A");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"B");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testDirectFromRouteReceived() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).fromRoute("foo").whenReceived(1).create();
        NotifyBuilderTest.assertEquals((String)"fromRoute(foo).whenReceived(1)", (String)notify.toString());
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"A");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"B");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testWhenExchangeDone() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenDone(5).create();
        NotifyBuilderTest.assertEquals((String)"from(direct:foo).whenDone(5)", (String)notify.toString());
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        this.template.sendBody("direct:bar", (Object)"D");
        this.template.sendBody("direct:bar", (Object)"E");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"F");
        this.template.sendBody("direct:bar", (Object)"G");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"H");
        this.template.sendBody("direct:bar", (Object)"I");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testWhenExchangeDoneAnd() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenDone(5).and().from("direct:bar").whenDone(7).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        this.template.sendBody("direct:bar", (Object)"D");
        this.template.sendBody("direct:bar", (Object)"E");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"F");
        this.template.sendBody("direct:bar", (Object)"G");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"H");
        this.template.sendBody("direct:bar", (Object)"I");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"J");
        this.template.sendBody("direct:bar", (Object)"K");
        this.template.sendBody("direct:bar", (Object)"L");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testFromRouteWhenExchangeDoneAnd() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).fromRoute("foo").whenDone(5).and().fromRoute("bar").whenDone(7).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        this.template.sendBody("direct:bar", (Object)"D");
        this.template.sendBody("direct:bar", (Object)"E");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"F");
        this.template.sendBody("direct:bar", (Object)"G");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"H");
        this.template.sendBody("direct:bar", (Object)"I");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"J");
        this.template.sendBody("direct:bar", (Object)"K");
        this.template.sendBody("direct:bar", (Object)"L");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testFromRouteAndNot() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).fromRoute("foo").whenDone(2).and().fromRoute("bar").whenReceived(1).not().fromRoute("cake").whenDone(1).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"C");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"D");
        this.template.sendBody("direct:bar", (Object)"E");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:cake", (Object)"F");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
    }

    public void testWhenExchangeDoneOr() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenDone(5).or().from("direct:bar").whenDone(7).create();
        NotifyBuilderTest.assertEquals((String)"from(direct:foo).whenDone(5).or().from(direct:bar).whenDone(7)", (String)notify.toString());
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        this.template.sendBody("direct:bar", (Object)"D");
        this.template.sendBody("direct:bar", (Object)"E");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"G");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"I");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"J");
        this.template.sendBody("direct:bar", (Object)"K");
        this.template.sendBody("direct:bar", (Object)"L");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testWhenExchangeDoneNot() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenDone(5).not().from("direct:bar").whenDone(1).create();
        NotifyBuilderTest.assertEquals((String)"from(direct:foo).whenDone(5).not().from(direct:bar).whenDone(1)", (String)notify.toString());
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        this.template.sendBody("direct:foo", (Object)"D");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"E");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"F");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"G");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
    }

    public void testWhenExchangeDoneOrFailure() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(5).or().whenFailed(1).create();
        NotifyBuilderTest.assertEquals((String)"whenDone(5).or().whenFailed(1)", (String)notify.toString());
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"D");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        try {
            this.template.sendBody("direct:fail", (Object)"E");
            NotifyBuilderTest.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testWhenExchangeDoneNotFailure() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(5).not().whenFailed(1).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"D");
        this.template.sendBody("direct:bar", (Object)"E");
        this.template.sendBody("direct:bar", (Object)"F");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        try {
            this.template.sendBody("direct:fail", (Object)"G");
            NotifyBuilderTest.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
    }

    public void testFilterWhenExchangeDone() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).filter(NotifyBuilderTest.body().contains((Object)"World")).whenDone(3).create();
        NotifyBuilderTest.assertEquals((String)"filter(simple{${body}} contains World).whenDone(3)", (String)notify.toString());
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.template.sendBody("direct:foo", (Object)"Hi World");
        this.template.sendBody("direct:foo", (Object)"A");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"B");
        this.template.sendBody("direct:bar", (Object)"C");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Bye World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"D");
        this.template.sendBody("direct:bar", (Object)"Hey World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testFromFilterWhenExchangeDone() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").filter(NotifyBuilderTest.body().contains((Object)"World")).whenDone(3).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.template.sendBody("direct:foo", (Object)"Hi World");
        this.template.sendBody("direct:foo", (Object)"A");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Bye World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"D");
        this.template.sendBody("direct:foo", (Object)"Hey World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"E");
        this.template.sendBody("direct:foo", (Object)"Hi Again World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testFromFilterBuilderWhenExchangeDone() throws Exception {
        NotifyBuilder notify = ((NotifyBuilder)new NotifyBuilder((CamelContext)this.context).filter().xpath("/person[@name='James']")).whenDone(1).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"<person name='Claus'/>");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"<person name='Jonathan'/>");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"<person name='James'/>");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"<person name='Hadrian'/>");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testWhenExchangeCompleted() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenCompleted(5).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:bar", (Object)"C");
        try {
            this.template.sendBody("direct:fail", (Object)"D");
            NotifyBuilderTest.fail((String)"Should have thrown exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.template.sendBody("direct:fail", (Object)"E");
            NotifyBuilderTest.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"F");
        this.template.sendBody("direct:foo", (Object)"G");
        this.template.sendBody("direct:bar", (Object)"H");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testWhenExchangeExactlyDone() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenExactlyDone(5).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        this.template.sendBody("direct:bar", (Object)"D");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"E");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"F");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
    }

    public void testWhenExchangeExactlyComplete() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenExactlyCompleted(5).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        this.template.sendBody("direct:bar", (Object)"D");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"E");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"F");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
    }

    public void testWhenExchangeExactlyFailed() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenExactlyFailed(2).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        try {
            this.template.sendBody("direct:fail", (Object)"D");
            NotifyBuilderTest.fail((String)"Should have thrown exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.template.sendBody("direct:bar", (Object)"E");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        try {
            this.template.sendBody("direct:fail", (Object)"F");
            NotifyBuilderTest.fail((String)"Should have thrown exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"G");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        try {
            this.template.sendBody("direct:fail", (Object)"H");
            NotifyBuilderTest.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
    }

    public void testWhenAnyReceivedMatches() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenAnyReceivedMatches(NotifyBuilderTest.body().contains((Object)"Camel")).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Hello Camel");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testWhenAllReceivedMatches() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenAllReceivedMatches(NotifyBuilderTest.body().contains((Object)"Camel")).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello Camel");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye Camel");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Hello World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
    }

    public void testWhenAnyDoneMatches() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenAnyDoneMatches(NotifyBuilderTest.body().contains((Object)"Bye")).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hi World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:cake", (Object)"Camel");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Damn World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testWhenAllDoneMatches() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenAllDoneMatches(NotifyBuilderTest.body().contains((Object)"Bye")).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:cake", (Object)"Camel");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:cake", (Object)"World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hi World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
    }

    public void testWhenBodiesReceived() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenBodiesReceived(new Object[]{"Hi World", "Hello World"}).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hi World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Damn World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testWhenBodiesDone() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenBodiesDone(new Object[]{"Bye World", "Bye Camel"}).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.requestBody("direct:cake", (Object)"World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:cake", (Object)"Camel");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Damn World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testWhenExactBodiesReceived() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenExactBodiesReceived(new Object[]{"Hi World", "Hello World"}).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hi World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Damn World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
    }

    public void testWhenExactBodiesDone() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenExactBodiesDone(new Object[]{"Bye World", "Bye Camel"}).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.requestBody("direct:cake", (Object)"World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:cake", (Object)"Camel");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Damn World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
    }

    public void testWhenReceivedSatisfied() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:assert");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World", "Hi World"});
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenDoneSatisfied(mock).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Hi World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hi World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testWhenReceivedNotSatisfied() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:assert");
        mock.expectedMessageCount(2);
        ((ValueBuilder)mock.message(1).body()).contains((Object)"Camel");
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenReceivedNotSatisfied(mock).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello Camel");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
    }

    public void testWhenNotSatisfiedUsingSatisfied() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:assert");
        mock.expectedMessageCount(2);
        ((ValueBuilder)mock.message(1).body()).contains((Object)"Camel");
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenReceivedSatisfied(mock).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello Camel");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testComplexOrCamel() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:assert");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World", "Hi World"});
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenReceivedSatisfied(mock).and().from("direct:bar").whenExactlyDone(5).whenAnyReceivedMatches(NotifyBuilderTest.body().contains((Object)"Camel")).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Hi World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hi World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Hi Camel");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"A");
        this.template.sendBody("direct:bar", (Object)"B");
        this.template.sendBody("direct:bar", (Object)"C");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testWhenDoneSatisfied() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:assert");
        mock.expectedBodiesReceived(new Object[]{"Bye World", "Bye Camel"});
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDoneSatisfied(mock).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.requestBody("direct:cake", (Object)"World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.requestBody("direct:cake", (Object)"Camel");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.requestBody("direct:cake", (Object)"Damn");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testWhenDoneNotSatisfied() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:assert");
        mock.expectedBodiesReceived(new Object[]{"Bye World", "Bye Camel"});
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDoneNotSatisfied(mock).create();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.requestBody("direct:cake", (Object)"World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.requestBody("direct:cake", (Object)"Camel");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.requestBody("direct:cake", (Object)"Damn");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
    }

    public void testReset() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenExactlyDone(1).create();
        this.template.sendBody("direct:foo", (Object)"Hello World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        notify.reset();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
    }

    public void testResetBodiesReceived() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenBodiesReceived(new Object[]{"Hello World", "Bye World"}).create();
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.template.sendBody("direct:foo", (Object)"Bye World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
        notify.reset();
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testOneNonAbstractPredicate() throws Exception {
        try {
            new NotifyBuilder((CamelContext)this.context).wereSentTo("mock:foo").create();
            NotifyBuilderTest.fail((String)"Should throw exception");
        }
        catch (IllegalArgumentException e) {
            NotifyBuilderTest.assertEquals((String)"NotifyBuilder must contain at least one non-abstract predicate (such as whenDone)", (String)e.getMessage());
        }
    }

    public void testWereSentTo() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).wereSentTo("mock:foo").whenDone(1).create();
        this.template.sendBody("direct:bar", (Object)"Hello World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testTwoWereSentTo() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).wereSentTo("log:beer").wereSentTo("mock:beer").whenDone(1).create();
        this.template.sendBody("direct:bar", (Object)"Hello World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:beer", (Object)"Bye World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testWhenDoneWereSentTo() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(2).wereSentTo("mock:beer").create();
        this.template.sendBody("direct:bar", (Object)"A");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:beer", (Object)"B");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"C");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"D");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:cake", (Object)"E");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:beer", (Object)"F");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testWereSentToWhenDone() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).wereSentTo("mock:beer").whenDone(2).create();
        this.template.sendBody("direct:bar", (Object)"A");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:beer", (Object)"B");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"C");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"D");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:cake", (Object)"E");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:beer", (Object)"F");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testTwoWereSentToRegExp() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).wereSentTo(".*beer.*").whenDone(1).create();
        this.template.sendBody("direct:bar", (Object)"Hello World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:beer", (Object)"Bye World");
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    public void testTwoWereSentToDoneAndFailed() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(2).wereSentTo("mock:bar").and().whenFailed(1).wereSentTo("mock:fail").create();
        this.template.sendBody("direct:bar", (Object)"Hello World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Hello World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        NotifyBuilderTest.assertEquals((boolean)false, (boolean)notify.matches());
        try {
            this.template.sendBody("direct:fail", (Object)"Bye World");
            NotifyBuilderTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException camelExecutionException) {
            // empty catch block
        }
        NotifyBuilderTest.assertEquals((boolean)true, (boolean)notify.matches());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").routeId("foo").to("mock:foo");
                ((RouteDefinition)this.from("direct:bar").routeId("bar").to("log:bar")).to("mock:bar");
                ((RouteDefinition)this.from("direct:fail").routeId("fail").to("mock:fail")).throwException((Exception)new IllegalArgumentException("Damn"));
                ((RouteDefinition)this.from("direct:cake").routeId("cake").transform((Expression)this.body().prepend((Object)"Bye "))).to("log:cake");
                ((RouteDefinition)this.from("direct:beer").routeId("beer").to("log:beer")).to("mock:beer");
            }
        };
    }
}

