/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.Date;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.ExpectedBodyTypeException;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.InvalidPayloadRuntimeException;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.NoSuchPropertyException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.RuntimeExpressionException;
import org.apache.camel.RuntimeTransformException;
import org.apache.camel.ServiceStatus;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.impl.DefaultExchange;

public class CamelExceptionsTest
extends ContextTestSupport {
    public void testExpectedBodyTypeException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        ExpectedBodyTypeException e = new ExpectedBodyTypeException((Exchange)exchange, Integer.class);
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e.getExchange());
        CamelExceptionsTest.assertEquals(Integer.class, (Object)e.getExpectedBodyType());
    }

    public void testExpressionEvaluationException() {
        Expression exp = ExpressionBuilder.constantExpression((Object)"foo");
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        ExpressionEvaluationException e = new ExpressionEvaluationException(exp, (Exchange)exchange, (Throwable)new IllegalArgumentException("Damn"));
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e.getExchange());
        CamelExceptionsTest.assertSame((Object)exp, (Object)e.getExpression());
        CamelExceptionsTest.assertNotNull((Object)e.getCause());
    }

    public void testFailedToCreateConsumerException() {
        Endpoint endpoint = this.context.getEndpoint("seda:foo");
        FailedToCreateConsumerException e = new FailedToCreateConsumerException(endpoint, (Throwable)new IllegalArgumentException("Damn"));
        CamelExceptionsTest.assertEquals((String)endpoint.getEndpointUri(), (String)e.getUri());
        CamelExceptionsTest.assertNotNull((Object)e.getCause());
    }

    public void testFailedToCreateProducerException() {
        Endpoint endpoint = this.context.getEndpoint("seda:foo");
        FailedToCreateProducerException e = new FailedToCreateProducerException(endpoint, (Throwable)new IllegalArgumentException("Damn"));
        CamelExceptionsTest.assertEquals((String)endpoint.getEndpointUri(), (String)e.getUri());
        CamelExceptionsTest.assertNotNull((Object)e.getCause());
    }

    public void testInvalidPayloadRuntimeException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        InvalidPayloadRuntimeException e = new InvalidPayloadRuntimeException((Exchange)exchange, Integer.class);
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e.getExchange());
        CamelExceptionsTest.assertEquals(Integer.class, (Object)e.getType());
        InvalidPayloadRuntimeException e2 = new InvalidPayloadRuntimeException((Exchange)exchange, Integer.class, exchange.getIn());
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e2.getExchange());
        CamelExceptionsTest.assertEquals(Integer.class, (Object)e2.getType());
        InvalidPayloadRuntimeException e3 = new InvalidPayloadRuntimeException((Exchange)exchange, Integer.class, exchange.getIn(), (Throwable)new IllegalArgumentException("Damn"));
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e3.getExchange());
        CamelExceptionsTest.assertEquals(Integer.class, (Object)e3.getType());
    }

    public void testRuntimeTransformException() {
        RuntimeTransformException e = new RuntimeTransformException("Forced");
        CamelExceptionsTest.assertEquals((String)"Forced", (String)e.getMessage());
        CamelExceptionsTest.assertNull((Object)e.getCause());
        RuntimeTransformException e2 = new RuntimeTransformException("Forced", (Throwable)new IllegalAccessException("Damn"));
        CamelExceptionsTest.assertEquals((String)"Forced", (String)e2.getMessage());
        CamelExceptionsTest.assertNotNull((Object)e2.getCause());
        RuntimeTransformException e3 = new RuntimeTransformException((Throwable)new IllegalAccessException("Damn"));
        CamelExceptionsTest.assertEquals((String)"java.lang.IllegalAccessException: Damn", (String)e3.getMessage());
        CamelExceptionsTest.assertNotNull((Object)e3.getCause());
    }

    public void testRuntimeExpressionException() {
        RuntimeExpressionException e = new RuntimeExpressionException("Forced");
        CamelExceptionsTest.assertEquals((String)"Forced", (String)e.getMessage());
        CamelExceptionsTest.assertNull((Object)e.getCause());
        RuntimeExpressionException e2 = new RuntimeExpressionException("Forced", (Throwable)new IllegalAccessException("Damn"));
        CamelExceptionsTest.assertEquals((String)"Forced", (String)e2.getMessage());
        CamelExceptionsTest.assertNotNull((Object)e2.getCause());
        RuntimeExpressionException e3 = new RuntimeExpressionException((Throwable)new IllegalAccessException("Damn"));
        CamelExceptionsTest.assertEquals((String)"java.lang.IllegalAccessException: Damn", (String)e3.getMessage());
        CamelExceptionsTest.assertNotNull((Object)e3.getCause());
    }

    public void testRollbackExchangeException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        RollbackExchangeException e = new RollbackExchangeException((Exchange)exchange, (Throwable)new IllegalAccessException("Damn"));
        CamelExceptionsTest.assertNotNull((Object)e.getMessage());
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e.getExchange());
        RollbackExchangeException e2 = new RollbackExchangeException("Forced", (Exchange)exchange, (Throwable)new IllegalAccessException("Damn"));
        CamelExceptionsTest.assertNotNull((Object)e2.getMessage());
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e2.getExchange());
    }

    public void testValidationException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        ValidationException e = new ValidationException((Exchange)exchange, "Forced");
        CamelExceptionsTest.assertNotNull((Object)e.getMessage());
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e.getExchange());
        ValidationException e2 = new ValidationException("Forced", (Exchange)exchange, (Throwable)new IllegalAccessException("Damn"));
        CamelExceptionsTest.assertNotNull((Object)e2.getMessage());
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e2.getExchange());
    }

    public void testNoSuchBeanException() {
        NoSuchBeanException e = new NoSuchBeanException("foo");
        CamelExceptionsTest.assertEquals((String)"foo", (String)e.getName());
        CamelExceptionsTest.assertNull((Object)e.getCause());
        NoSuchBeanException e2 = new NoSuchBeanException("foo", (Throwable)new IllegalArgumentException("Damn"));
        CamelExceptionsTest.assertEquals((String)"foo", (String)e2.getName());
        CamelExceptionsTest.assertNotNull((Object)e2.getCause());
    }

    public void testCamelExecutionException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        CamelExecutionException e = new CamelExecutionException("Forced", (Exchange)exchange);
        CamelExceptionsTest.assertNotNull((Object)e.getMessage());
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e.getExchange());
        CamelExceptionsTest.assertNull((Object)e.getCause());
        CamelExecutionException e2 = new CamelExecutionException("Forced", (Exchange)exchange, (Throwable)new IllegalArgumentException("Damn"));
        CamelExceptionsTest.assertNotNull((Object)e2.getMessage());
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e2.getExchange());
        CamelExceptionsTest.assertNotNull((Object)e2.getCause());
    }

    public void testCamelException() {
        CamelException e = new CamelException();
        CamelExceptionsTest.assertNull((Object)e.getCause());
        CamelException e2 = new CamelException("Forced");
        CamelExceptionsTest.assertNull((Object)e2.getCause());
        CamelExceptionsTest.assertEquals((String)"Forced", (String)e2.getMessage());
        CamelException e3 = new CamelException("Forced", (Throwable)new IllegalArgumentException("Damn"));
        CamelExceptionsTest.assertNotNull((Object)e3.getCause());
        CamelExceptionsTest.assertEquals((String)"Forced", (String)e3.getMessage());
        CamelException e4 = new CamelException((Throwable)new IllegalArgumentException("Damn"));
        CamelExceptionsTest.assertNotNull((Object)e4.getCause());
        CamelExceptionsTest.assertNotNull((Object)e4.getMessage());
    }

    public void testServiceStatus() {
        CamelExceptionsTest.assertTrue((boolean)ServiceStatus.Started.isStarted());
        CamelExceptionsTest.assertFalse((boolean)ServiceStatus.Starting.isStarted());
        CamelExceptionsTest.assertFalse((boolean)ServiceStatus.Starting.isStoppable());
        CamelExceptionsTest.assertFalse((boolean)ServiceStatus.Stopped.isStarted());
        CamelExceptionsTest.assertFalse((boolean)ServiceStatus.Stopping.isStarted());
        CamelExceptionsTest.assertTrue((boolean)ServiceStatus.Stopped.isStopped());
        CamelExceptionsTest.assertFalse((boolean)ServiceStatus.Starting.isStopped());
        CamelExceptionsTest.assertFalse((boolean)ServiceStatus.Started.isStopped());
        CamelExceptionsTest.assertFalse((boolean)ServiceStatus.Stopping.isStopped());
        CamelExceptionsTest.assertTrue((boolean)ServiceStatus.Stopped.isStartable());
        CamelExceptionsTest.assertFalse((boolean)ServiceStatus.Started.isStartable());
        CamelExceptionsTest.assertFalse((boolean)ServiceStatus.Starting.isStartable());
        CamelExceptionsTest.assertFalse((boolean)ServiceStatus.Stopping.isStartable());
        CamelExceptionsTest.assertTrue((boolean)ServiceStatus.Started.isStoppable());
        CamelExceptionsTest.assertFalse((boolean)ServiceStatus.Starting.isStoppable());
        CamelExceptionsTest.assertFalse((boolean)ServiceStatus.Stopped.isStoppable());
        CamelExceptionsTest.assertFalse((boolean)ServiceStatus.Stopping.isStoppable());
    }

    public void testRuntimeExchangeException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        RuntimeExchangeException e = new RuntimeExchangeException("Forced", (Exchange)exchange);
        CamelExceptionsTest.assertNotNull((Object)e.getMessage());
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e.getExchange());
        RuntimeExchangeException e2 = new RuntimeExchangeException("Forced", null);
        CamelExceptionsTest.assertNotNull((Object)e2.getMessage());
        CamelExceptionsTest.assertNull((Object)e2.getExchange());
    }

    public void testExchangePattern() {
        CamelExceptionsTest.assertTrue((boolean)ExchangePattern.InOnly.isInCapable());
        CamelExceptionsTest.assertTrue((boolean)ExchangePattern.InOptionalOut.isInCapable());
        CamelExceptionsTest.assertTrue((boolean)ExchangePattern.InOut.isInCapable());
        CamelExceptionsTest.assertFalse((boolean)ExchangePattern.RobustOutOnly.isInCapable());
        CamelExceptionsTest.assertFalse((boolean)ExchangePattern.InOnly.isFaultCapable());
        CamelExceptionsTest.assertTrue((boolean)ExchangePattern.InOptionalOut.isFaultCapable());
        CamelExceptionsTest.assertTrue((boolean)ExchangePattern.InOut.isFaultCapable());
        CamelExceptionsTest.assertFalse((boolean)ExchangePattern.InOnly.isOutCapable());
        CamelExceptionsTest.assertTrue((boolean)ExchangePattern.InOptionalOut.isOutCapable());
        CamelExceptionsTest.assertTrue((boolean)ExchangePattern.InOut.isOutCapable());
        CamelExceptionsTest.assertEquals((Object)ExchangePattern.InOnly, (Object)ExchangePattern.asEnum((String)"InOnly"));
        CamelExceptionsTest.assertEquals((Object)ExchangePattern.InOut, (Object)ExchangePattern.asEnum((String)"InOut"));
        try {
            ExchangePattern.asEnum((String)"foo");
            CamelExceptionsTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInvalidPayloadException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        InvalidPayloadException e = new InvalidPayloadException((Exchange)exchange, Integer.class);
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e.getExchange());
        CamelExceptionsTest.assertEquals(Integer.class, (Object)e.getType());
    }

    public void testExchangeTimedOutException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        ExchangeTimedOutException e = new ExchangeTimedOutException((Exchange)exchange, 5000L);
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e.getExchange());
        CamelExceptionsTest.assertEquals((long)5000L, (long)e.getTimeout());
    }

    public void testExpressionIllegalSyntaxException() {
        ExpressionIllegalSyntaxException e = new ExpressionIllegalSyntaxException("foo");
        CamelExceptionsTest.assertEquals((String)"foo", (String)e.getExpression());
    }

    public void testNoFactoryAvailableException() {
        NoFactoryAvailableException e = new NoFactoryAvailableException("killer", (Throwable)new IllegalArgumentException("Damn"));
        CamelExceptionsTest.assertNotNull((Object)e.getCause());
        CamelExceptionsTest.assertEquals((String)"killer", (String)e.getUri());
    }

    public void testCamelExchangeException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        CamelExchangeException e = new CamelExchangeException("Forced", (Exchange)exchange);
        CamelExceptionsTest.assertNotNull((Object)e.getMessage());
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e.getExchange());
    }

    public void testNoSuchHeaderException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        NoSuchHeaderException e = new NoSuchHeaderException((Exchange)exchange, "foo", Integer.class);
        CamelExceptionsTest.assertEquals(Integer.class, (Object)e.getType());
        CamelExceptionsTest.assertEquals((String)"foo", (String)e.getHeaderName());
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e.getExchange());
    }

    public void testNoSuchPropertyException() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        NoSuchPropertyException e = new NoSuchPropertyException((Exchange)exchange, "foo", Integer.class);
        CamelExceptionsTest.assertEquals(Integer.class, (Object)e.getType());
        CamelExceptionsTest.assertEquals((String)"foo", (String)e.getPropertyName());
        CamelExceptionsTest.assertSame((Object)exchange, (Object)e.getExchange());
    }

    public void testRuntimeCamelException() {
        RuntimeCamelException e = new RuntimeCamelException();
        CamelExceptionsTest.assertNull((Object)e.getMessage());
        CamelExceptionsTest.assertNull((Object)e.getCause());
    }

    public void testFailedToStartRouteException() {
        FailedToStartRouteException e = new FailedToStartRouteException((Throwable)new IllegalArgumentException("Forced"));
        CamelExceptionsTest.assertNotNull((Object)e.getMessage());
        CamelExceptionsTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
    }

    public void testNoTypeConversionAvailableException() {
        NoTypeConversionAvailableException e = new NoTypeConversionAvailableException((Object)"foo", Date.class);
        CamelExceptionsTest.assertEquals((Object)"foo", (Object)e.getValue());
        CamelExceptionsTest.assertEquals(Date.class, (Object)e.getToType());
        CamelExceptionsTest.assertEquals(String.class, (Object)e.getFromType());
        NoTypeConversionAvailableException e2 = new NoTypeConversionAvailableException(null, Date.class);
        CamelExceptionsTest.assertNull((Object)e2.getValue());
        CamelExceptionsTest.assertEquals(Date.class, (Object)e2.getToType());
        CamelExceptionsTest.assertNull(null, (Object)e2.getFromType());
    }

    public void testResolveEndpointFailedException() {
        ResolveEndpointFailedException e = new ResolveEndpointFailedException("foo:bar");
        CamelExceptionsTest.assertEquals((String)"foo:bar", (String)e.getUri());
    }
}

