/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import java.io.InputStream;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Service;
import org.apache.camel.component.cache.CacheConfiguration;
import org.apache.camel.component.cache.CacheEndpoint;
import org.apache.camel.component.cache.CacheManagerFactory;
import org.apache.camel.component.cache.DefaultCacheManagerFactory;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.apache.camel.util.ServiceHelper;

public class CacheComponent
extends UriEndpointComponent {
    private CacheConfiguration configuration = new CacheConfiguration();
    private CacheManagerFactory cacheManagerFactory;
    private String configurationFile;

    public CacheComponent() {
        super(CacheEndpoint.class);
    }

    public CacheComponent(CamelContext context) {
        super(context, CacheEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        CacheConfiguration config = this.configuration.copy();
        this.setProperties((Object)this, parameters);
        this.setProperties(config, parameters);
        config.setCacheName(remaining);
        CacheEndpoint cacheEndpoint = new CacheEndpoint(uri, (Component)this, config, this.cacheManagerFactory);
        this.setProperties((Object)cacheEndpoint, parameters);
        return cacheEndpoint;
    }

    public CacheManagerFactory getCacheManagerFactory() {
        return this.cacheManagerFactory;
    }

    public void setCacheManagerFactory(CacheManagerFactory cacheManagerFactory) {
        this.cacheManagerFactory = cacheManagerFactory;
    }

    public CacheConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CacheConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationFile(String configurationFile) {
        this.configurationFile = configurationFile;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.cacheManagerFactory == null) {
            if (this.configurationFile != null) {
                InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.configurationFile);
                this.cacheManagerFactory = new DefaultCacheManagerFactory(is, this.configurationFile);
            } else {
                this.cacheManagerFactory = new DefaultCacheManagerFactory();
            }
        }
        ServiceHelper.startService((Service)this.cacheManagerFactory);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)((Object)this.cacheManagerFactory));
        super.doStop();
    }
}

