/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache.processor.idempotent;

import javax.cache.Cache;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.jcache.JCacheConfiguration;
import org.apache.camel.component.jcache.JCacheManager;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ServiceSupport;

@ManagedResource(description="JCache based message id repository")
public class JCacheIdempotentRepository
extends ServiceSupport
implements IdempotentRepository<Object> {
    private JCacheConfiguration configuration = new JCacheConfiguration();
    private String cacheName;
    private ClassLoader classLoader;
    private CamelContext camelContext;
    private Cache<Object, Boolean> cache;
    private JCacheManager<Object, Boolean> cacheManager;

    public JCacheConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JCacheConfiguration configuration) {
        this.configuration = configuration;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Cache<Object, Boolean> getCache() {
        return this.cache;
    }

    public void setCache(Cache<Object, Boolean> cache) {
        this.cache = cache;
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(Object key) {
        return this.cache.putIfAbsent(key, (Object)true);
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(Object key) {
        return this.cache.containsKey(key);
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(Object key) {
        return this.cache.remove(key);
    }

    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.cache.clear();
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    @ManagedAttribute(description="The processor name")
    public String getCacheName() {
        return this.cacheName;
    }

    public boolean confirm(Object key) {
        return this.cache.replace(key, (Object)false, (Object)true);
    }

    protected void doStart() throws Exception {
        if (this.cache != null) {
            this.cacheManager = new JCacheManager<Object, Boolean>(this.cache);
        } else {
            this.cacheManager = new JCacheManager(this.configuration, this.cacheName, this.classLoader, this.camelContext);
            this.cache = this.cacheManager.getCache();
        }
    }

    protected void doStop() throws Exception {
        this.cacheManager.close();
    }
}

