/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.spi.CachingProvider;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jcache.JCacheConfiguration;
import org.apache.camel.component.jcache.JCacheEntryEventFilters;
import org.apache.camel.util.ObjectHelper;

public class JCacheManager<K, V>
implements Closeable {
    private JCacheConfiguration configuration;
    private CachingProvider provider;
    private CacheManager manager;
    private ClassLoader classLoader;
    private Cache<K, V> cache;
    private String cacheName;
    private CamelContext camelContext;

    public JCacheManager(JCacheConfiguration configuration, String cacheName) {
        this(configuration, cacheName, null, null);
    }

    public JCacheManager(JCacheConfiguration configuration, String cacheName, CamelContext camelContext) {
        this(configuration, cacheName, null, camelContext);
    }

    public JCacheManager(JCacheConfiguration configuration, String cacheName, ClassLoader classLoader) {
        this(configuration, cacheName, classLoader, null);
    }

    public JCacheManager(JCacheConfiguration configuration, String cacheName, ClassLoader classLoader, CamelContext camelContext) {
        this.configuration = configuration;
        this.provider = null;
        this.manager = null;
        this.classLoader = classLoader;
        this.cache = null;
        this.cacheName = cacheName;
        this.camelContext = camelContext;
    }

    public JCacheManager(Cache<K, V> cache) {
        this.cache = cache;
        this.configuration = null;
        this.cacheName = cache.getName();
        this.provider = null;
        this.manager = null;
        this.camelContext = null;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public JCacheConfiguration getConfiguration() {
        return this.configuration;
    }

    public synchronized Cache<K, V> getCache() throws Exception {
        if (this.cache == null) {
            String uri = this.configuration.getConfigurationUri();
            if (uri != null && this.camelContext != null) {
                uri = this.camelContext.resolvePropertyPlaceholders(uri);
            }
            this.provider = this.configuration.getCachingProvider() != null ? Caching.getCachingProvider((String)this.configuration.getCachingProvider()) : Caching.getCachingProvider();
            this.manager = this.provider.getCacheManager(ObjectHelper.isNotEmpty((Object)uri) ? URI.create(uri) : null, this.classLoader, this.configuration.getCacheConfigurationProperties());
            this.cache = this.manager.getCache(this.cacheName);
            if (this.cache == null) {
                if (!this.configuration.isCreateCacheIfNotExists()) {
                    throw new IllegalStateException("Cache " + this.cacheName + " does not exist and should not be created (createCacheIfNotExists=false)");
                }
                this.cache = this.manager.createCache(this.cacheName, this.getOrCreateCacheConfiguration());
            }
        }
        return this.cache;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.configuration != null) {
            if (this.cache != null) {
                this.cache.close();
            }
            if (this.manager != null) {
                this.manager.close();
            }
            if (this.provider != null) {
                this.provider.close();
            }
        }
    }

    Configuration getOrCreateCacheConfiguration() {
        if (this.configuration.getCacheConfiguration() != null) {
            return this.configuration.getCacheConfiguration();
        }
        MutableConfiguration mutableConfiguration = new MutableConfiguration();
        if (this.configuration.getCacheLoaderFactory() != null) {
            mutableConfiguration.setCacheLoaderFactory(this.configuration.getCacheLoaderFactory());
        }
        if (this.configuration.getCacheWriterFactory() != null) {
            mutableConfiguration.setCacheWriterFactory(this.configuration.getCacheWriterFactory());
        }
        if (this.configuration.getExpiryPolicyFactory() != null) {
            mutableConfiguration.setExpiryPolicyFactory(this.configuration.getExpiryPolicyFactory());
        }
        mutableConfiguration.setManagementEnabled(this.configuration.isManagementEnabled());
        mutableConfiguration.setStatisticsEnabled(this.configuration.isStatisticsEnabled());
        mutableConfiguration.setReadThrough(this.configuration.isReadThrough());
        mutableConfiguration.setStoreByValue(this.configuration.isStoreByValue());
        mutableConfiguration.setWriteThrough(this.configuration.isWriteThrough());
        return mutableConfiguration;
    }

    CacheEntryEventFilter getEventFilter() {
        if (this.configuration.getEventFilters() != null) {
            return new JCacheEntryEventFilters.Chained(this.configuration.getEventFilters());
        }
        return new JCacheEntryEventFilters.Named(this.configuration.getFilteredEvents());
    }
}

