/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.EventType;

class JCacheEntryEventFilters {
    JCacheEntryEventFilters() {
    }

    public static class Chained
    implements CacheEntryEventFilter<Object, Object> {
        private final List<CacheEntryEventFilter> filteredEvents;
        private final int filteredEventsSize;

        public Chained(List<CacheEntryEventFilter> filteredEvents) {
            if (filteredEvents != null && !filteredEvents.isEmpty()) {
                this.filteredEvents = new ArrayList<CacheEntryEventFilter>(filteredEvents);
                this.filteredEventsSize = this.filteredEvents.size();
            } else {
                this.filteredEvents = null;
                this.filteredEventsSize = 0;
            }
        }

        public boolean evaluate(CacheEntryEvent<?, ?> event) throws CacheEntryListenerException {
            if (this.filteredEvents == null) {
                return true;
            }
            for (int i = 0; i < this.filteredEventsSize; ++i) {
                if (this.filteredEvents.get(i).evaluate(event)) continue;
                return false;
            }
            return true;
        }
    }

    public static class Named
    implements CacheEntryEventFilter<Object, Object> {
        private List<EventType> filteredEvents;

        public Named(Collection<EventType> filteredEventNames) {
            if (filteredEventNames != null && !filteredEventNames.isEmpty()) {
                this.filteredEvents = new ArrayList<EventType>(filteredEventNames);
            }
        }

        public boolean evaluate(CacheEntryEvent<?, ?> event) throws CacheEntryListenerException {
            if (this.filteredEvents == null) {
                return true;
            }
            return !this.filteredEvents.contains(event.getEventType());
        }
    }
}

