/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hipchat;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.hipchat.HipchatEndpoint;
import org.apache.camel.component.hipchat.HipchatException;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HipchatComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(HipchatComponent.class);

    public HipchatComponent() {
        super(HipchatEndpoint.class);
    }

    public HipchatComponent(CamelContext context) {
        super(context, HipchatEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        HipchatEndpoint endpoint = this.getHipchatEndpoint(uri);
        this.setProperties(endpoint.getConfiguration(), parameters);
        if (endpoint.getConfiguration().getAuthToken() == null) {
            throw new HipchatException("OAuth 2 auth token must be specified");
        }
        this.parseUri(uri, endpoint);
        LOG.debug("Using Hipchat API URL: {}", (Object)endpoint.getConfiguration().hipChatUrl());
        return endpoint;
    }

    private void parseUri(String uri, HipchatEndpoint endpoint) throws Exception {
        uri = ObjectHelper.after((String)uri, (String)":");
        URI hipChatUri = new URI(uri = URISupport.normalizeUri((String)uri));
        if (hipChatUri.getHost() != null) {
            endpoint.getConfiguration().setHost(hipChatUri.getHost());
            if (hipChatUri.getPort() != -1) {
                endpoint.getConfiguration().setPort(hipChatUri.getPort());
            }
            endpoint.getConfiguration().setProtocol(hipChatUri.getScheme());
        }
    }

    protected HipchatEndpoint getHipchatEndpoint(String uri) {
        return new HipchatEndpoint(uri, this);
    }
}

