/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo2.api.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.apache.camel.component.olingo2.api.Olingo2ResponseHandler;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;

public abstract class AbstractFutureCallback<T>
implements FutureCallback<HttpResponse> {
    public static final Pattern ODATA_MIME_TYPE = Pattern.compile("application/((atom)|(json)|(xml)).*");
    private final Olingo2ResponseHandler<T> responseHandler;

    AbstractFutureCallback(Olingo2ResponseHandler<T> responseHandler) {
        this.responseHandler = responseHandler;
    }

    public static HttpStatusCodes checkStatus(HttpResponse response) throws ODataApplicationException {
        StatusLine statusLine = response.getStatusLine();
        HttpStatusCodes httpStatusCode = HttpStatusCodes.fromStatusCode((int)statusLine.getStatusCode());
        if (400 <= httpStatusCode.getStatusCode() && httpStatusCode.getStatusCode() <= 599) {
            if (response.getEntity() != null) {
                try {
                    ContentType responseContentType = ContentType.parse((String)response.getFirstHeader("Content-Type").getValue());
                    String mimeType = responseContentType.getMimeType();
                    if (ODATA_MIME_TYPE.matcher(mimeType).matches()) {
                        ODataErrorContext errorContext = EntityProvider.readErrorDocument((InputStream)response.getEntity().getContent(), (String)responseContentType.toString());
                        throw new ODataApplicationException(errorContext.getMessage(), errorContext.getLocale(), httpStatusCode, errorContext.getErrorCode(), (Throwable)errorContext.getException());
                    }
                }
                catch (EntityProviderException e) {
                    throw new ODataApplicationException(e.getMessage(), response.getLocale(), httpStatusCode, (Throwable)e);
                }
                catch (IOException e) {
                    throw new ODataApplicationException(e.getMessage(), response.getLocale(), httpStatusCode, (Throwable)e);
                }
            }
            throw new ODataApplicationException(statusLine.getReasonPhrase(), response.getLocale(), httpStatusCode);
        }
        return httpStatusCode;
    }

    public final void completed(HttpResponse result) {
        try {
            AbstractFutureCallback.checkStatus(result);
            this.onCompleted(result);
        }
        catch (Exception e) {
            this.failed(e);
        }
    }

    protected abstract void onCompleted(HttpResponse var1) throws ODataException, IOException;

    public final void failed(Exception ex) {
        this.responseHandler.onException(ex);
    }

    public final void cancelled() {
        this.responseHandler.onCanceled();
    }
}

