/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.Undertow;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndertowRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowRegistry.class);
    private int port;
    private SSLContext sslContext;
    private String host;
    private Undertow server;
    private Map<String, UndertowConsumer> consumersRegistry = new HashMap<String, UndertowConsumer>();

    public UndertowRegistry(UndertowConsumer consumer, int port) {
        this.registerConsumer(consumer);
        this.port = port;
        if (consumer.getEndpoint().getSslContext() != null) {
            this.sslContext = consumer.getEndpoint().getSslContext();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void registerConsumer(UndertowConsumer consumer) {
        UndertowEndpoint endpoint = consumer.getEndpoint();
        URI httpUri = endpoint.getHttpURI();
        if (this.host != null && !this.host.equals(httpUri.getHost())) {
            throw new IllegalArgumentException("Cannot register UndertowConsumer on different host and same port: {}" + this.host + " " + httpUri.getHost());
        }
        this.host = httpUri.getHost();
        LOG.info("Adding consumer to consumerRegistry: {}", (Object)httpUri);
        this.consumersRegistry.put(endpoint.getEndpointUri(), consumer);
        if (this.sslContext != null && endpoint.getSslContext() != null) {
            throw new IllegalArgumentException("Cannot register UndertowConsumer with different SSL config");
        }
    }

    public void unregisterConsumer(UndertowConsumer consumer) {
        UndertowEndpoint endpoint = consumer.getEndpoint();
        String endpointUri = endpoint.getEndpointUri();
        if (this.consumersRegistry.containsKey(endpointUri)) {
            this.consumersRegistry.remove(endpointUri);
        } else {
            LOG.debug("Cannot unregister consumer {} as it was not registered", (Object)consumer);
        }
    }

    public boolean isEmpty() {
        return this.consumersRegistry.isEmpty();
    }

    public Undertow getServer() {
        return this.server;
    }

    public void setServer(Undertow server) {
        this.server = server;
    }

    public Map<String, UndertowConsumer> getConsumersRegistry() {
        return this.consumersRegistry;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }
}

