/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.server.HttpServerExchange;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.undertow.DefaultUndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowComponent;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowHeaderFilterStrategy;
import org.apache.camel.component.undertow.UndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

@UriEndpoint(scheme="undertow", title="Undertow", syntax="undertow:httpURI", consumerClass=UndertowConsumer.class, label="http", lenientProperties=true)
public class UndertowEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowEndpoint.class);
    private UndertowComponent component;
    private SSLContext sslContext;
    private OptionMap optionMap;
    @UriPath
    @Metadata(required="true")
    private URI httpURI;
    @UriParam(label="advanced")
    private UndertowHttpBinding undertowHttpBinding;
    @UriParam(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy = new UndertowHeaderFilterStrategy();
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="consumer")
    private String httpMethodRestrict;
    @UriParam(label="consumer", defaultValue="true")
    private Boolean matchOnUriPrefix = true;
    @UriParam(label="producer")
    private Boolean throwExceptionOnFailure;
    @UriParam
    private Boolean transferException;
    @UriParam(label="producer", defaultValue="true")
    private Boolean keepAlive = Boolean.TRUE;
    @UriParam(label="producer", defaultValue="true")
    private Boolean tcpNoDelay = Boolean.TRUE;
    @UriParam(label="producer", defaultValue="true")
    private Boolean reuseAddresses = Boolean.TRUE;
    @UriParam(label="producer", prefix="option.", multiValue=true)
    private Map<String, Object> options;
    @UriParam(label="consumer", description="Specifies whether to enable HTTP OPTIONS for this Servlet consumer. By default OPTIONS is turned off.")
    private boolean optionsEnabled;

    public UndertowEndpoint(String uri, UndertowComponent component) throws URISyntaxException {
        super(uri, (Component)component);
        this.component = component;
    }

    public UndertowComponent getComponent() {
        return this.component;
    }

    public Producer createProducer() throws Exception {
        return new UndertowProducer(this, this.optionMap);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new UndertowConsumer(this, processor);
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        throw new UnsupportedOperationException("This component does not support polling consumer");
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public Exchange createExchange(HttpServerExchange httpExchange) throws Exception {
        Exchange exchange = this.createExchange();
        Message in = this.getUndertowHttpBinding().toCamelMessage(httpExchange, exchange);
        exchange.setProperty("CamelCharsetName", (Object)httpExchange.getRequestCharset());
        in.setHeader("CamelHttpCharacterEncoding", (Object)httpExchange.getRequestCharset());
        exchange.setIn(in);
        return exchange;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public URI getHttpURI() {
        return this.httpURI;
    }

    public void setHttpURI(URI httpURI) {
        this.httpURI = httpURI;
    }

    public String getHttpMethodRestrict() {
        return this.httpMethodRestrict;
    }

    public void setHttpMethodRestrict(String httpMethodRestrict) {
        this.httpMethodRestrict = httpMethodRestrict;
    }

    public Boolean getMatchOnUriPrefix() {
        return this.matchOnUriPrefix;
    }

    public void setMatchOnUriPrefix(Boolean matchOnUriPrefix) {
        this.matchOnUriPrefix = matchOnUriPrefix;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public Boolean getThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(Boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public Boolean getTransferException() {
        return this.transferException;
    }

    public void setTransferException(Boolean transferException) {
        this.transferException = transferException;
    }

    public UndertowHttpBinding getUndertowHttpBinding() {
        if (this.undertowHttpBinding == null) {
            this.undertowHttpBinding = new DefaultUndertowHttpBinding();
            this.undertowHttpBinding.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
        return this.undertowHttpBinding;
    }

    public void setUndertowHttpBinding(UndertowHttpBinding undertowHttpBinding) {
        this.undertowHttpBinding = undertowHttpBinding;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(Boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public Boolean getReuseAddresses() {
        return this.reuseAddresses;
    }

    public void setReuseAddresses(Boolean reuseAddresses) {
        this.reuseAddresses = reuseAddresses;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public boolean isOptionsEnabled() {
        return this.optionsEnabled;
    }

    public void setOptionsEnabled(boolean optionsEnabled) {
        this.optionsEnabled = optionsEnabled;
    }

    protected void doStart() throws Exception {
        OptionMap.Builder builder;
        super.doStart();
        if (this.sslContextParameters != null) {
            this.sslContext = this.sslContextParameters.createSSLContext();
        }
        if (this.options != null && !this.options.isEmpty()) {
            ClassLoader cl = this.getComponent().getCamelContext().getApplicationContextClassLoader();
            if (cl == null) {
                cl = Options.class.getClassLoader();
            }
            OptionMap.Builder builder2 = OptionMap.builder();
            for (Map.Entry<String, Object> entry : this.options.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                key = key.toUpperCase(Locale.ENGLISH).replace('-', '_');
                key = Options.class.getName() + "." + key;
                Option option = Option.fromString((String)key, (ClassLoader)cl);
                value = option.parseValue(value.toString(), cl);
                LOG.trace("Parsed option {}={}", (Object)option.getName(), value);
                builder2.set(option, value);
            }
            this.optionMap = builder2.getMap();
        } else {
            this.optionMap = OptionMap.EMPTY;
        }
        if (this.keepAlive != null && !this.optionMap.contains(Options.KEEP_ALIVE)) {
            builder = OptionMap.builder();
            builder.addAll(this.optionMap).set(Options.KEEP_ALIVE, (Object)this.keepAlive);
            this.optionMap = builder.getMap();
        }
        if (this.tcpNoDelay != null && !this.optionMap.contains(Options.TCP_NODELAY)) {
            builder = OptionMap.builder();
            builder.addAll(this.optionMap).set(Options.TCP_NODELAY, (Object)this.tcpNoDelay);
            this.optionMap = builder.getMap();
        }
        if (this.reuseAddresses != null && !this.optionMap.contains(Options.REUSE_ADDRESSES)) {
            builder = OptionMap.builder();
            builder.addAll(this.optionMap).set(Options.REUSE_ADDRESSES, (Object)this.tcpNoDelay);
            this.optionMap = builder.getMap();
        }
    }
}

