/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.server.HttpHandler;
import java.net.URI;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.undertow.HttpHandlerRegistrationInfo;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.UndertowHost;
import org.apache.camel.component.undertow.handlers.HttpCamelHandler;
import org.apache.camel.impl.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndertowConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowConsumer.class);
    private UndertowHost undertowHost;
    private HttpHandlerRegistrationInfo registrationInfo;

    public UndertowConsumer(UndertowEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public UndertowEndpoint getEndpoint() {
        return (UndertowEndpoint)super.getEndpoint();
    }

    public UndertowHost getUndertowHost() {
        if (this.undertowHost == null) {
            this.undertowHost = this.createUndertowHost();
        }
        return this.undertowHost;
    }

    protected UndertowHost createUndertowHost() {
        return new DefaultUndertowHost();
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("Undertow consumer is starting");
        this.getEndpoint().getComponent().registerConsumer(this);
        UndertowHost host = this.getUndertowHost();
        HttpCamelHandler httpCamelHandler = new HttpCamelHandler();
        httpCamelHandler.connectConsumer(this);
        HttpHandlerRegistrationInfo registrationInfo = this.getHttpHandlerRegistrationInfo();
        host.validateEndpointURI(registrationInfo.getUri());
        host.registerHandler(registrationInfo, httpCamelHandler);
    }

    protected void doStop() {
        LOG.debug("Undertow consumer is stopping");
        HttpHandlerRegistrationInfo registrationInfo = this.getHttpHandlerRegistrationInfo();
        UndertowHost host = this.getUndertowHost();
        host.unregisterHandler(registrationInfo);
        this.getEndpoint().getComponent().unregisterConsumer(this);
    }

    private HttpHandlerRegistrationInfo getHttpHandlerRegistrationInfo() {
        if (this.registrationInfo == null) {
            UndertowEndpoint endpoint = this.getEndpoint();
            this.registrationInfo = new HttpHandlerRegistrationInfo();
            this.registrationInfo.setUri(endpoint.getHttpURI());
            this.registrationInfo.setMethodRestrict(endpoint.getHttpMethodRestrict());
            this.registrationInfo.setMatchOnUriPrefix(endpoint.getMatchOnUriPrefix());
        }
        return this.registrationInfo;
    }

    class DefaultUndertowHost
    implements UndertowHost {
        DefaultUndertowHost() {
        }

        @Override
        public void validateEndpointURI(URI httpURI) {
        }

        @Override
        public void registerHandler(HttpHandlerRegistrationInfo registrationInfo, HttpHandler handler) {
            UndertowConsumer.this.getEndpoint().getComponent().startServer(UndertowConsumer.this);
        }

        @Override
        public void unregisterHandler(HttpHandlerRegistrationInfo registrationInfo) {
        }
    }
}

