/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.leveldb;

import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Service;
import org.apache.camel.component.leveldb.LevelDBCamelCodec;
import org.apache.camel.component.leveldb.LevelDBFile;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.WriteBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelDBAggregationRepository
extends ServiceSupport
implements RecoverableAggregationRepository {
    private static final Logger LOG = LoggerFactory.getLogger(LevelDBAggregationRepository.class);
    private LevelDBFile levelDBFile;
    private String persistentFileName;
    private String repositoryName;
    private boolean sync;
    private boolean returnOldExchange;
    private LevelDBCamelCodec codec = new LevelDBCamelCodec();
    private long recoveryInterval = 5000L;
    private boolean useRecovery = true;
    private int maximumRedeliveries;
    private String deadLetterUri;
    private boolean allowSerializedHeaders;

    public LevelDBAggregationRepository() {
    }

    public LevelDBAggregationRepository(String repositoryName) {
        ObjectHelper.notEmpty((String)repositoryName, (String)"repositoryName");
        this.repositoryName = repositoryName;
    }

    public LevelDBAggregationRepository(String repositoryName, String persistentFileName) {
        ObjectHelper.notEmpty((String)repositoryName, (String)"repositoryName");
        ObjectHelper.notEmpty((String)persistentFileName, (String)"persistentFileName");
        this.repositoryName = repositoryName;
        this.persistentFileName = persistentFileName;
    }

    public LevelDBAggregationRepository(String repositoryName, LevelDBFile levelDBFile) {
        ObjectHelper.notEmpty((String)repositoryName, (String)"repositoryName");
        ObjectHelper.notNull((Object)levelDBFile, (String)"levelDBFile");
        this.levelDBFile = levelDBFile;
        this.repositoryName = repositoryName;
    }

    public Exchange add(CamelContext camelContext, String key, Exchange exchange) {
        LOG.debug("Adding key [{}] -> {}", (Object)key, (Object)exchange);
        try {
            byte[] lDbKey = LevelDBAggregationRepository.keyBuilder(this.repositoryName, key);
            Buffer exchangeBuffer = this.codec.marshallExchange(camelContext, exchange, this.allowSerializedHeaders);
            byte[] rc = null;
            if (this.isReturnOldExchange()) {
                rc = this.levelDBFile.getDb().get(lDbKey);
            }
            LOG.trace("Adding key index {} for repository {}", (Object)key, (Object)this.repositoryName);
            this.levelDBFile.getDb().put(lDbKey, exchangeBuffer.toByteArray(), this.levelDBFile.getWriteOptions());
            LOG.trace("Added key index {}", (Object)key);
            if (rc == null) {
                return null;
            }
            if (this.isReturnOldExchange()) {
                return this.codec.unmarshallExchange(camelContext, new Buffer(rc));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error adding to repository " + this.repositoryName + " with key " + key, e);
        }
        return null;
    }

    public Exchange get(CamelContext camelContext, String key) {
        Exchange answer = null;
        try {
            byte[] lDbKey = LevelDBAggregationRepository.keyBuilder(this.repositoryName, key);
            LOG.trace("Getting key index {}", (Object)key);
            byte[] rc = this.levelDBFile.getDb().get(lDbKey);
            if (rc != null) {
                answer = this.codec.unmarshallExchange(camelContext, new Buffer(rc));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting key " + key + " from repository " + this.repositoryName, e);
        }
        LOG.debug("Getting key  [{}] -> {}", (Object)key, answer);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CamelContext camelContext, String key, Exchange exchange) {
        block5: {
            LOG.debug("Removing key [{}]", (Object)key);
            try {
                byte[] lDbKey = LevelDBAggregationRepository.keyBuilder(this.repositoryName, key);
                String exchangeId = exchange.getExchangeId();
                Buffer exchangeBuffer = this.codec.marshallExchange(camelContext, exchange, this.allowSerializedHeaders);
                byte[] rc = this.levelDBFile.getDb().get(lDbKey);
                if (rc == null) break block5;
                try (WriteBatch batch = this.levelDBFile.getDb().createWriteBatch();){
                    batch.delete(lDbKey);
                    LOG.trace("Removed key index {} -> {}", (Object)key, (Object)new Buffer(rc));
                    byte[] confirmedLDBKey = LevelDBAggregationRepository.keyBuilder(this.getRepositoryNameCompleted(), exchangeId);
                    batch.put(confirmedLDBKey, exchangeBuffer.toByteArray());
                    LOG.trace("Added confirm index {} for repository {}", (Object)exchangeId, (Object)this.getRepositoryNameCompleted());
                    this.levelDBFile.getDb().write(batch, this.levelDBFile.getWriteOptions());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error removing key " + key + " from repository " + this.repositoryName, e);
            }
        }
    }

    public void confirm(CamelContext camelContext, String exchangeId) {
        LOG.debug("Confirming exchangeId [{}]", (Object)exchangeId);
        byte[] confirmedLDBKey = LevelDBAggregationRepository.keyBuilder(this.getRepositoryNameCompleted(), exchangeId);
        byte[] rc = this.levelDBFile.getDb().get(confirmedLDBKey);
        if (rc != null) {
            this.levelDBFile.getDb().delete(confirmedLDBKey);
            LOG.trace("Removed confirm index {} -> {}", (Object)exchangeId, (Object)new Buffer(rc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeys() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        if (!this.isRunAllowed()) {
            return null;
        }
        DBIterator it = this.levelDBFile.getDb().iterator();
        try {
            String prefix = this.repositoryName + '\u0000';
            it.seek(LevelDBAggregationRepository.keyBuilder(this.repositoryName, ""));
            while (it.hasNext()) {
                if (!this.isRunAllowed()) {
                    break;
                }
                String keyBuffer = JniDBFactory.asString((byte[])((byte[])it.peekNext().getKey()));
                if (!keyBuffer.startsWith(prefix)) {
                    break;
                }
                String key = keyBuffer.substring(prefix.length());
                LOG.trace("getKey [{}]", (Object)key);
                keys.add(key);
                it.next();
            }
        }
        finally {
            IOHelper.close((Closeable)it);
        }
        return Collections.unmodifiableSet(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> scan(CamelContext camelContext) {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        if (!this.isRunAllowed()) {
            return null;
        }
        DBIterator it = this.levelDBFile.getDb().iterator();
        try {
            String prefix = this.getRepositoryNameCompleted() + '\u0000';
            it.seek(LevelDBAggregationRepository.keyBuilder(this.getRepositoryNameCompleted(), ""));
            while (it.hasNext()) {
                String keyBuffer = JniDBFactory.asString((byte[])((byte[])it.peekNext().getKey()));
                if (!keyBuffer.startsWith(prefix)) {
                    break;
                }
                String exchangeId = keyBuffer.substring(prefix.length());
                LOG.trace("Scan exchangeId [{}]", (Object)exchangeId);
                answer.add(exchangeId);
                it.next();
            }
        }
        finally {
            IOHelper.close((Closeable)it);
        }
        if (answer.size() == 0) {
            LOG.trace("Scanned and found no exchange to recover.");
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Scanned and found {} exchange(s) to recover (note some of them may already be in progress).", (Object)answer.size());
        }
        return answer;
    }

    public Exchange recover(CamelContext camelContext, String exchangeId) {
        Exchange answer = null;
        try {
            byte[] completedLDBKey = LevelDBAggregationRepository.keyBuilder(this.getRepositoryNameCompleted(), exchangeId);
            byte[] rc = this.levelDBFile.getDb().get(completedLDBKey);
            if (rc != null) {
                answer = this.codec.unmarshallExchange(camelContext, new Buffer(rc));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error recovering exchangeId " + exchangeId + " from repository " + this.repositoryName, e);
        }
        LOG.debug("Recovering exchangeId [{}] -> {}", (Object)exchangeId, answer);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int size(String repositoryName) {
        DBIterator it = this.levelDBFile.getDb().iterator();
        String prefix = repositoryName + '\u0000';
        int count = 0;
        try {
            it.seek(LevelDBAggregationRepository.keyBuilder(repositoryName, ""));
            while (it.hasNext()) {
                if (!JniDBFactory.asString((byte[])((byte[])it.peekNext().getKey())).startsWith(prefix)) {
                    break;
                }
                ++count;
                it.next();
            }
        }
        finally {
            IOHelper.close((Closeable)it);
        }
        LOG.debug("Size of repository [{}] -> {}", (Object)repositoryName, (Object)count);
        return count;
    }

    public LevelDBFile getLevelDBFile() {
        return this.levelDBFile;
    }

    public void setLevelDBFile(LevelDBFile levelDBFile) {
        this.levelDBFile = levelDBFile;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    private String getRepositoryNameCompleted() {
        return this.repositoryName + "-completed";
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isReturnOldExchange() {
        return this.returnOldExchange;
    }

    public void setReturnOldExchange(boolean returnOldExchange) {
        this.returnOldExchange = returnOldExchange;
    }

    public void setRecoveryInterval(long interval, TimeUnit timeUnit) {
        this.recoveryInterval = timeUnit.toMillis(interval);
    }

    public void setRecoveryInterval(long interval) {
        this.recoveryInterval = interval;
    }

    public long getRecoveryIntervalInMillis() {
        return this.recoveryInterval;
    }

    public boolean isUseRecovery() {
        return this.useRecovery;
    }

    public void setUseRecovery(boolean useRecovery) {
        this.useRecovery = useRecovery;
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetterUri = deadLetterUri;
    }

    public String getPersistentFileName() {
        return this.persistentFileName;
    }

    public void setPersistentFileName(String persistentFileName) {
        this.persistentFileName = persistentFileName;
    }

    public boolean isAllowSerializedHeaders() {
        return this.allowSerializedHeaders;
    }

    public void setAllowSerializedHeaders(boolean allowSerializedHeaders) {
        this.allowSerializedHeaders = allowSerializedHeaders;
    }

    protected void doStart() throws Exception {
        if (this.levelDBFile == null && this.persistentFileName != null) {
            this.levelDBFile = new LevelDBFile();
            this.levelDBFile.setSync(this.isSync());
            this.levelDBFile.setFileName(this.persistentFileName);
        }
        ObjectHelper.notNull((Object)this.levelDBFile, (String)"Either set a persistentFileName or a levelDBFile");
        ObjectHelper.notNull((Object)this.repositoryName, (String)"repositoryName");
        ServiceHelper.startService((Service)this.levelDBFile);
        int current = this.size(this.getRepositoryName());
        int completed = this.size(this.getRepositoryNameCompleted());
        if (current > 0) {
            LOG.info("On startup there are " + current + " aggregate exchanges (not completed) in repository: " + this.getRepositoryName());
        } else {
            LOG.info("On startup there are no existing aggregate exchanges (not completed) in repository: " + this.getRepositoryName());
        }
        if (completed > 0) {
            LOG.warn("On startup there are " + completed + " completed exchanges to be recovered in repository: " + this.getRepositoryNameCompleted());
        } else {
            LOG.info("On startup there are no completed exchanges to be recovered in repository: " + this.getRepositoryNameCompleted());
        }
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.levelDBFile);
    }

    public static byte[] keyBuilder(String repo, String key) {
        try {
            return (repo + '\u0000' + key).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

