/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.queue;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IQueue;
import java.util.Collection;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.HazelcastDefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class HazelcastQueueProducer
extends HazelcastDefaultProducer {
    private IQueue<Object> queue;

    public HazelcastQueueProducer(HazelcastInstance hazelcastInstance, HazelcastDefaultEndpoint endpoint, String queueName) {
        super(endpoint);
        this.queue = hazelcastInstance.getQueue(queueName);
    }

    public void process(Exchange exchange) throws Exception {
        Map headers = exchange.getIn().getHeaders();
        Object draintToCollection = null;
        if (headers.containsKey("CamelHazelcastDrainToCollection")) {
            draintToCollection = headers.get("CamelHazelcastDrainToCollection");
        }
        int operation = this.lookupOperationNumber(exchange);
        switch (operation) {
            case -1: 
            case 31: {
                this.add(exchange);
                break;
            }
            case 1: {
                this.put(exchange);
                break;
            }
            case 34: {
                this.poll(exchange);
                break;
            }
            case 33: {
                this.peek(exchange);
                break;
            }
            case 32: {
                this.offer(exchange);
                break;
            }
            case 17: {
                this.remove(exchange);
                break;
            }
            case 35: {
                this.remainingCapacity(exchange);
                break;
            }
            case 36: {
                if (ObjectHelper.isNotEmpty(draintToCollection)) {
                    this.drainTo(draintToCollection, exchange);
                    break;
                }
                throw new IllegalArgumentException("Drain to collection header must be specified");
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the QUEUE cache.", operation, "CamelHazelcastOperationType"));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void add(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.queue.add(body);
    }

    private void put(Exchange exchange) throws InterruptedException {
        Object body = exchange.getIn().getBody();
        this.queue.put(body);
    }

    private void poll(Exchange exchange) {
        exchange.getOut().setBody(this.queue.poll());
    }

    private void peek(Exchange exchange) {
        exchange.getOut().setBody(this.queue.peek());
    }

    private void offer(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.queue.offer(body);
    }

    private void remove(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        if (body != null) {
            this.queue.remove(body);
        } else {
            this.queue.remove();
        }
    }

    private void remainingCapacity(Exchange exchange) {
        exchange.getOut().setBody((Object)this.queue.remainingCapacity());
    }

    private void drainTo(Collection c, Exchange exchange) {
        exchange.getOut().setBody((Object)this.queue.drainTo(c));
        exchange.getOut().setHeader("CamelHazelcastDrainToCollection", (Object)c);
    }
}

