/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.spring.integration.SpringIntegrationComponent;
import org.apache.camel.component.spring.integration.SpringIntegrationConsumer;
import org.apache.camel.component.spring.integration.SpringIntegrationProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.spring.SpringCamelContext;
import org.springframework.messaging.MessageChannel;

@UriEndpoint(scheme="spring-integration", title="Spring Integration", syntax="spring-integration:defaultChannel", consumerClass=SpringIntegrationConsumer.class, label="spring,eventbus")
public class SpringIntegrationEndpoint
extends DefaultEndpoint {
    private MessageChannel messageChannel;
    @UriPath
    @Metadata(required="true")
    private String defaultChannel;
    @UriParam(label="consumer")
    private String inputChannel;
    @UriParam(label="producer")
    private String outputChannel;
    @UriParam
    private boolean inOut;

    public SpringIntegrationEndpoint(String uri, String channel, SpringIntegrationComponent component) {
        super(uri, (Component)component);
        this.defaultChannel = channel;
    }

    @Deprecated
    public SpringIntegrationEndpoint(String uri, MessageChannel channel, CamelContext context) {
        super(uri, context);
        this.messageChannel = channel;
    }

    @Deprecated
    public SpringIntegrationEndpoint(String endpointUri, MessageChannel messageChannel) {
        super(endpointUri);
        this.messageChannel = messageChannel;
    }

    public Producer createProducer() throws Exception {
        return new SpringIntegrationProducer((SpringCamelContext)this.getCamelContext(), this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        SpringIntegrationConsumer answer = new SpringIntegrationConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public void setInputChannel(String input) {
        this.inputChannel = input;
    }

    public String getInputChannel() {
        return this.inputChannel;
    }

    public void setOutputChannel(String output) {
        this.outputChannel = output;
    }

    public String getOutputChannel() {
        return this.outputChannel;
    }

    public void setDefaultChannel(String defaultChannel) {
        this.defaultChannel = defaultChannel;
    }

    public String getDefaultChannel() {
        return this.defaultChannel;
    }

    @Deprecated
    public MessageChannel getMessageChannel() {
        return this.messageChannel;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setInOut(boolean inOut) {
        this.inOut = inOut;
    }

    public boolean isInOut() {
        return this.inOut;
    }
}

