/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.Service;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.internal.dto.LoginError;
import org.apache.camel.component.salesforce.internal.dto.LoginToken;
import org.apache.camel.util.ObjectHelper;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.FormContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceSession
implements Service {
    private static final String OAUTH2_REVOKE_PATH = "/services/oauth2/revoke?token=";
    private static final String OAUTH2_TOKEN_PATH = "/services/oauth2/token";
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceSession.class);
    private final SalesforceHttpClient httpClient;
    private final long timeout;
    private final SalesforceLoginConfig config;
    private final ObjectMapper objectMapper;
    private final Set<SalesforceSessionListener> listeners;
    private volatile String accessToken;
    private volatile String instanceUrl;

    public SalesforceSession(SalesforceHttpClient httpClient, long timeout, SalesforceLoginConfig config) {
        ObjectHelper.notNull((Object)((Object)httpClient), (String)"httpClient");
        ObjectHelper.notNull((Object)config, (String)"SalesforceLoginConfig");
        ObjectHelper.notNull((Object)config.getLoginUrl(), (String)"loginUrl");
        ObjectHelper.notNull((Object)config.getClientId(), (String)"clientId");
        ObjectHelper.notNull((Object)config.getClientSecret(), (String)"clientSecret");
        ObjectHelper.notNull((Object)config.getUserName(), (String)"userName");
        ObjectHelper.notNull((Object)config.getPassword(), (String)"password");
        this.httpClient = httpClient;
        this.timeout = timeout;
        this.config = config;
        String loginUrl = config.getLoginUrl();
        config.setLoginUrl(loginUrl.endsWith("/") ? loginUrl.substring(0, loginUrl.length() - 1) : loginUrl);
        this.objectMapper = new ObjectMapper();
        this.listeners = new CopyOnWriteArraySet<SalesforceSessionListener>();
    }

    public synchronized String login(String oldToken) throws SalesforceException {
        if (this.accessToken == null || this.accessToken.equals(oldToken)) {
            this.accessToken = oldToken;
            if (this.accessToken != null) {
                try {
                    this.logout();
                }
                catch (SalesforceException e) {
                    LOG.warn("Error revoking old access token: " + e.getMessage(), (Throwable)((Object)e));
                }
                this.accessToken = null;
            }
            Request loginPost = this.getLoginRequest(null);
            try {
                ContentResponse loginResponse = loginPost.send();
                this.parseLoginResponse(loginResponse, loginResponse.getContentAsString());
            }
            catch (InterruptedException e) {
                throw new SalesforceException("Login error: " + e.getMessage(), e);
            }
            catch (TimeoutException e) {
                throw new SalesforceException("Login request timeout: " + e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new SalesforceException("Unexpected login error: " + e.getCause().getMessage(), e.getCause());
            }
        }
        return this.accessToken;
    }

    public Request getLoginRequest(HttpConversation conversation) {
        String loginUrl = (this.instanceUrl == null ? this.config.getLoginUrl() : this.instanceUrl) + OAUTH2_TOKEN_PATH;
        LOG.info("Login user {} at Salesforce loginUrl: {}", (Object)this.config.getUserName(), (Object)loginUrl);
        Fields fields = new Fields(true);
        fields.put("grant_type", "password");
        fields.put("client_id", this.config.getClientId());
        fields.put("client_secret", this.config.getClientSecret());
        fields.put("username", this.config.getUserName());
        fields.put("password", this.config.getPassword());
        fields.put("format", "json");
        Request post = conversation == null ? this.httpClient.POST(loginUrl) : this.httpClient.newHttpRequest(conversation, URI.create(loginUrl)).method(HttpMethod.POST);
        return post.content((ContentProvider)new FormContentProvider(fields)).timeout(this.timeout, TimeUnit.MILLISECONDS);
    }

    public synchronized void parseLoginResponse(ContentResponse loginResponse, String responseContent) throws SalesforceException {
        int responseStatus = loginResponse.getStatus();
        try {
            switch (responseStatus) {
                case 200: {
                    LoginToken token = (LoginToken)this.objectMapper.readValue(responseContent, LoginToken.class);
                    LOG.info("Login successful");
                    this.accessToken = token.getAccessToken();
                    this.instanceUrl = token.getInstanceUrl();
                    for (SalesforceSessionListener listener : this.listeners) {
                        try {
                            listener.onLogin(this.accessToken, this.instanceUrl);
                        }
                        catch (Throwable t) {
                            LOG.warn("Unexpected error from listener {}: {}", (Object)listener, (Object)t.getMessage());
                        }
                    }
                    break;
                }
                case 400: {
                    LoginError error = (LoginError)this.objectMapper.readValue(responseContent, LoginError.class);
                    String msg = String.format("Login error code:[%s] description:[%s]", error.getError(), error.getErrorDescription());
                    ArrayList<RestError> errors = new ArrayList<RestError>();
                    errors.add(new RestError(msg, error.getErrorDescription()));
                    throw new SalesforceException(errors, 400);
                }
                default: {
                    throw new SalesforceException(String.format("Login error status:[%s] reason:[%s]", responseStatus, loginResponse.getReason()), responseStatus);
                }
            }
        }
        catch (IOException e) {
            String msg = "Login error: response parse exception " + e.getMessage();
            throw new SalesforceException(msg, e);
        }
    }

    public synchronized void logout() throws SalesforceException {
        block14: {
            if (this.accessToken == null) {
                return;
            }
            try {
                String logoutUrl = (this.instanceUrl == null ? this.config.getLoginUrl() : this.instanceUrl) + OAUTH2_REVOKE_PATH + this.accessToken;
                Request logoutGet = this.httpClient.newRequest(logoutUrl).timeout(this.timeout, TimeUnit.MILLISECONDS);
                ContentResponse logoutResponse = logoutGet.send();
                int statusCode = logoutResponse.getStatus();
                String reason = logoutResponse.getReason();
                if (statusCode == 200) {
                    LOG.info("Logout successful");
                    break block14;
                }
                throw new SalesforceException(String.format("Logout error, code: [%s] reason: [%s]", statusCode, reason), statusCode);
            }
            catch (InterruptedException e) {
                String msg = "Logout error: " + e.getMessage();
                throw new SalesforceException(msg, e);
            }
            catch (ExecutionException e) {
                Throwable ex = e.getCause();
                throw new SalesforceException("Unexpected logout exception: " + ex.getMessage(), ex);
            }
            catch (TimeoutException e) {
                throw new SalesforceException("Logout request TIMEOUT!", null);
            }
            finally {
                this.accessToken = null;
                this.instanceUrl = null;
                for (SalesforceSessionListener listener : this.listeners) {
                    try {
                        listener.onLogout();
                    }
                    catch (Throwable t) {
                        LOG.warn("Unexpected error from listener {}: {}", (Object)listener, (Object)t.getMessage());
                    }
                }
            }
        }
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    public boolean addListener(SalesforceSessionListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(SalesforceSessionListener listener) {
        return this.listeners.remove(listener);
    }

    public void start() throws Exception {
        this.login(this.accessToken);
    }

    public void stop() throws Exception {
        this.logout();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public static interface SalesforceSessionListener {
        public void onLogin(String var1, String var2);

        public void onLogout();
    }
}

