/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.producer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.sjms.MessageConsumerResources;
import org.apache.camel.component.sjms.MessageProducerResources;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.SjmsMessage;
import org.apache.camel.component.sjms.SjmsProducer;
import org.apache.camel.component.sjms.jms.JmsMessageHelper;
import org.apache.camel.component.sjms.jms.JmsObjectFactory;
import org.apache.camel.component.sjms.tx.SessionTransactionSynchronization;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class InOutProducer
extends SjmsProducer {
    private static final Map<String, Exchanger<Object>> EXCHANGERS = new ConcurrentHashMap<String, Exchanger<Object>>();
    private static final String GENERATED_CORRELATION_ID_PREFIX = "Camel-";
    private UuidGenerator uuidGenerator;
    private GenericObjectPool<MessageConsumerResources> consumers;

    public InOutProducer(SjmsEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public UuidGenerator getUuidGenerator() {
        return this.uuidGenerator;
    }

    public void setUuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }

    @Override
    protected void doStart() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.getNamedReplyTo())) {
            this.log.debug("No reply to destination is defined.  Using temporary destinations.");
        } else {
            this.log.debug("Using {} as the reply to destination.", (Object)this.getNamedReplyTo());
        }
        if (this.uuidGenerator == null) {
            this.uuidGenerator = this.getEndpoint().getCamelContext().getUuidGenerator();
        }
        if (this.consumers == null) {
            this.consumers = new GenericObjectPool((PoolableObjectFactory)new MessageConsumerResourcesFactory());
            this.consumers.setMaxActive(this.getConsumerCount());
            this.consumers.setMaxIdle(this.getConsumerCount());
            while (this.consumers.getNumIdle() < this.consumers.getMaxIdle()) {
                this.consumers.addObject();
            }
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.consumers != null) {
            this.consumers.close();
            this.consumers = null;
        }
    }

    @Override
    public MessageProducerResources doCreateProducerModel() throws Exception {
        MessageProducerResources answer;
        Connection conn = this.getConnectionResource().borrowConnection();
        try {
            Session session = conn.createSession(this.isEndpointTransacted(), this.getAcknowledgeMode());
            Destination destination = this.getEndpoint().getDestinationCreationStrategy().createDestination(session, this.getDestinationName(), this.isTopic());
            MessageProducer messageProducer = JmsObjectFactory.createMessageProducer(session, destination, this.isPersistent(), this.getTtl());
            answer = new MessageProducerResources(session, messageProducer);
        }
        catch (Exception e) {
            this.log.error("Unable to create the MessageProducer", (Throwable)e);
            throw e;
        }
        finally {
            this.getConnectionResource().returnConnection(conn);
        }
        return answer;
    }

    @Override
    public void sendMessage(Exchange exchange, AsyncCallback callback, MessageProducerResources producer) throws Exception {
        if (this.isEndpointTransacted()) {
            exchange.getUnitOfWork().addSynchronization((Synchronization)new SessionTransactionSynchronization(producer.getSession(), this.getCommitStrategy()));
        }
        javax.jms.Message request = this.getEndpoint().getBinding().makeJmsMessage(exchange, producer.getSession());
        String correlationId = (String)exchange.getIn().getHeader("JMSCorrelationID", String.class);
        if (correlationId == null) {
            correlationId = GENERATED_CORRELATION_ID_PREFIX + this.getUuidGenerator().generateUuid();
        }
        Object responseObject = null;
        Exchanger<Object> messageExchanger = new Exchanger<Object>();
        JmsMessageHelper.setCorrelationId(request, correlationId);
        EXCHANGERS.put(correlationId, messageExchanger);
        MessageConsumerResources consumer = (MessageConsumerResources)this.consumers.borrowObject();
        JmsMessageHelper.setJMSReplyTo(request, consumer.getReplyToDestination());
        this.consumers.returnObject((Object)consumer);
        producer.getMessageProducer().send(request);
        try {
            this.getProducers().returnObject((Object)producer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            responseObject = messageExchanger.exchange(null, this.getResponseTimeOut(), TimeUnit.MILLISECONDS);
            EXCHANGERS.remove(correlationId);
        }
        catch (InterruptedException e) {
            this.log.debug("Exchanger was interrupted while waiting on response", (Throwable)e);
            exchange.setException((Throwable)e);
        }
        catch (TimeoutException e) {
            this.log.debug("Exchanger timed out while waiting on response", (Throwable)e);
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() == null) {
            if (responseObject instanceof Throwable) {
                exchange.setException((Throwable)responseObject);
            } else if (responseObject instanceof javax.jms.Message) {
                javax.jms.Message message = responseObject;
                SjmsMessage response = new SjmsMessage(message, consumer.getSession(), this.getEndpoint().getBinding());
                exchange.setOut((Message)response);
            } else {
                exchange.setException((Throwable)new CamelException("Unknown response type: " + responseObject));
            }
        }
        callback.done(this.isSynchronous());
    }

    protected class MessageConsumerResourcesFactory
    extends BasePoolableObjectFactory<MessageConsumerResources> {
        protected MessageConsumerResourcesFactory() {
        }

        public MessageConsumerResources makeObject() throws Exception {
            MessageConsumerResources answer;
            Connection conn = InOutProducer.this.getConnectionResource().borrowConnection();
            try {
                Session session = InOutProducer.this.isEndpointTransacted() ? conn.createSession(true, 0) : conn.createSession(false, 1);
                Destination replyToDestination = ObjectHelper.isEmpty((Object)InOutProducer.this.getNamedReplyTo()) ? InOutProducer.this.getEndpoint().getDestinationCreationStrategy().createTemporaryDestination(session, InOutProducer.this.isTopic()) : InOutProducer.this.getEndpoint().getDestinationCreationStrategy().createDestination(session, InOutProducer.this.getNamedReplyTo(), InOutProducer.this.isTopic());
                MessageConsumer messageConsumer = JmsObjectFactory.createMessageConsumer(session, replyToDestination, null, InOutProducer.this.isTopic(), null, true);
                messageConsumer.setMessageListener(new MessageListener(){

                    public void onMessage(javax.jms.Message message) {
                        InOutProducer.this.log.debug("Message Received in the Consumer Pool");
                        InOutProducer.this.log.debug("  Message : {}", (Object)message);
                        try {
                            Exchanger exchanger = (Exchanger)EXCHANGERS.get(message.getJMSCorrelationID());
                            exchanger.exchange(message, InOutProducer.this.getResponseTimeOut(), TimeUnit.MILLISECONDS);
                        }
                        catch (Exception e) {
                            InOutProducer.this.log.error("Unable to exchange message: {}", (Object)message, (Object)e);
                        }
                    }
                });
                answer = new MessageConsumerResources(session, messageConsumer, replyToDestination);
            }
            catch (Exception e) {
                InOutProducer.this.log.error("Unable to create the MessageConsumerResource: " + e.getLocalizedMessage());
                throw new CamelException((Throwable)e);
            }
            finally {
                InOutProducer.this.getConnectionResource().returnConnection(conn);
            }
            return answer;
        }

        public void destroyObject(MessageConsumerResources model) throws Exception {
            if (model.getMessageConsumer() != null) {
                model.getMessageConsumer().close();
            }
            if (model.getSession() != null) {
                if (model.getSession().getTransacted()) {
                    try {
                        model.getSession().rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                model.getSession().close();
            }
        }
    }
}

