/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import javax.jms.Session;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.sjms.SjmsComponent;
import org.apache.camel.component.sjms.SjmsConsumer;
import org.apache.camel.component.sjms.SjmsHeaderFilterStrategy;
import org.apache.camel.component.sjms.SjmsMessage;
import org.apache.camel.component.sjms.SjmsProducer;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.jms.ConnectionResource;
import org.apache.camel.component.sjms.jms.DefaultDestinationCreationStrategy;
import org.apache.camel.component.sjms.jms.DefaultJmsKeyFormatStrategy;
import org.apache.camel.component.sjms.jms.DestinationCreationStrategy;
import org.apache.camel.component.sjms.jms.DestinationNameParser;
import org.apache.camel.component.sjms.jms.JmsBinding;
import org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.sjms.jms.MessageCreatedStrategy;
import org.apache.camel.component.sjms.jms.SessionAcknowledgementType;
import org.apache.camel.component.sjms.producer.InOnlyProducer;
import org.apache.camel.component.sjms.producer.InOutProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="sjms", title="Simple JMS", syntax="sjms:destinationType:destinationName", consumerClass=SjmsConsumer.class, label="messaging")
public class SjmsEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport,
HeaderFilterStrategyAware {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private boolean topic;
    private JmsBinding binding;
    @UriPath(enums="queue,topic", defaultValue="queue", description="The kind of destination to use")
    private String destinationType;
    @UriPath
    @Metadata(required="true")
    private String destinationName;
    @UriParam(label="consumer", defaultValue="true")
    private boolean synchronous = true;
    @UriParam(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy;
    @UriParam(label="advanced")
    private boolean includeAllJMSXProperties;
    @UriParam(label="consumer,transaction")
    private boolean transacted;
    @UriParam(label="producer")
    private String namedReplyTo;
    @UriParam(defaultValue="AUTO_ACKNOWLEDGE", enums="SESSION_TRANSACTED,CLIENT_ACKNOWLEDGE,AUTO_ACKNOWLEDGE,DUPS_OK_ACKNOWLEDGE")
    private SessionAcknowledgementType acknowledgementMode = SessionAcknowledgementType.AUTO_ACKNOWLEDGE;
    @Deprecated
    private int sessionCount = 1;
    @UriParam(label="producer", defaultValue="1")
    private int producerCount = 1;
    @UriParam(label="consumer", defaultValue="1")
    private int consumerCount = 1;
    @UriParam(label="producer", defaultValue="-1")
    private long ttl = -1L;
    @UriParam(label="producer", defaultValue="true")
    private boolean persistent = true;
    @UriParam(label="consumer")
    private String durableSubscriptionId;
    @UriParam(label="producer,advanced", defaultValue="5000")
    private long responseTimeOut = 5000L;
    @UriParam(label="consumer,advanced")
    private String messageSelector;
    @UriParam(label="consumer,transaction", defaultValue="-1")
    private int transactionBatchCount = -1;
    @UriParam(label="consumer,transaction", defaultValue="5000")
    private long transactionBatchTimeout = 5000L;
    @UriParam(label="advanced")
    private boolean asyncStartListener;
    @UriParam(label="advanced")
    private boolean asyncStopListener;
    @UriParam(label="producer,advanced", defaultValue="true")
    private boolean prefillPool = true;
    @UriParam(label="producer,advanced", defaultValue="true")
    private boolean allowNullBody = true;
    @UriParam(label="advanced", defaultValue="true")
    private boolean mapJmsMessage = true;
    @UriParam(label="transaction")
    private TransactionCommitStrategy transactionCommitStrategy;
    @UriParam(label="advanced")
    private DestinationCreationStrategy destinationCreationStrategy = new DefaultDestinationCreationStrategy();
    @UriParam(label="advanced")
    private MessageCreatedStrategy messageCreatedStrategy;
    @UriParam(label="advanced")
    private JmsKeyFormatStrategy jmsKeyFormatStrategy;

    public SjmsEndpoint() {
    }

    public SjmsEndpoint(String uri, Component component, String remaining) {
        super(uri, component);
        DestinationNameParser parser = new DestinationNameParser();
        this.topic = parser.isTopic(remaining);
        this.destinationName = parser.getShortName(remaining);
    }

    public SjmsComponent getComponent() {
        return (SjmsComponent)super.getComponent();
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public Producer createProducer() throws Exception {
        SjmsProducer producer = this.getExchangePattern().equals((Object)ExchangePattern.InOnly) ? new InOnlyProducer((Endpoint)this) : new InOutProducer(this);
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        SjmsConsumer answer = new SjmsConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    public boolean isSingleton() {
        return true;
    }

    public Exchange createExchange(javax.jms.Message message, Session session) {
        Exchange exchange = this.createExchange(this.getExchangePattern());
        exchange.setIn((Message)new SjmsMessage(message, session, this.getBinding()));
        return exchange;
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = this.createBinding();
        }
        return this.binding;
    }

    protected JmsBinding createBinding() {
        return new JmsBinding(this.isMapJmsMessage(), this.isAllowNullBody(), this.getHeaderFilterStrategy(), this.getJmsKeyFormatStrategy(), this.getMessageCreatedStrategy());
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new SjmsHeaderFilterStrategy(this.isIncludeAllJMSXProperties());
        }
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public boolean isIncludeAllJMSXProperties() {
        return this.includeAllJMSXProperties;
    }

    public void setIncludeAllJMSXProperties(boolean includeAllJMSXProperties) {
        this.includeAllJMSXProperties = includeAllJMSXProperties;
    }

    public ConnectionResource getConnectionResource() {
        return this.getComponent().getConnectionResource();
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public SessionAcknowledgementType getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public void setAcknowledgementMode(SessionAcknowledgementType acknowledgementMode) {
        this.acknowledgementMode = acknowledgementMode;
    }

    public boolean isTopic() {
        return this.topic;
    }

    @Deprecated
    public int getSessionCount() {
        return this.sessionCount;
    }

    @Deprecated
    public void setSessionCount(int sessionCount) {
        this.sessionCount = sessionCount;
    }

    public int getProducerCount() {
        return this.producerCount;
    }

    public void setProducerCount(int producerCount) {
        this.producerCount = producerCount;
    }

    public int getConsumerCount() {
        return this.consumerCount;
    }

    public void setConsumerCount(int consumerCount) {
        this.consumerCount = consumerCount;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public String getDurableSubscriptionId() {
        return this.durableSubscriptionId;
    }

    public void setDurableSubscriptionId(String durableSubscriptionId) {
        this.durableSubscriptionId = durableSubscriptionId;
    }

    public long getResponseTimeOut() {
        return this.responseTimeOut;
    }

    public void setResponseTimeOut(long responseTimeOut) {
        this.responseTimeOut = responseTimeOut;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public int getTransactionBatchCount() {
        return this.transactionBatchCount;
    }

    public void setTransactionBatchCount(int transactionBatchCount) {
        this.transactionBatchCount = transactionBatchCount;
    }

    public long getTransactionBatchTimeout() {
        return this.transactionBatchTimeout;
    }

    public void setTransactionBatchTimeout(long transactionBatchTimeout) {
        if (transactionBatchTimeout >= 1000L) {
            this.transactionBatchTimeout = transactionBatchTimeout;
        }
    }

    public TransactionCommitStrategy getTransactionCommitStrategy() {
        return this.transactionCommitStrategy;
    }

    public void setTransactionCommitStrategy(TransactionCommitStrategy transactionCommitStrategy) {
        this.transactionCommitStrategy = transactionCommitStrategy;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        if (transacted) {
            this.setAcknowledgementMode(SessionAcknowledgementType.SESSION_TRANSACTED);
        }
        this.transacted = transacted;
    }

    public String getNamedReplyTo() {
        return this.namedReplyTo;
    }

    public void setNamedReplyTo(String namedReplyTo) {
        this.namedReplyTo = namedReplyTo;
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public void setAsyncStartListener(boolean asyncStartListener) {
        this.asyncStartListener = asyncStartListener;
    }

    public void setAsyncStopListener(boolean asyncStopListener) {
        this.asyncStopListener = asyncStopListener;
    }

    public boolean isAsyncStartListener() {
        return this.asyncStartListener;
    }

    public boolean isAsyncStopListener() {
        return this.asyncStopListener;
    }

    public boolean isPrefillPool() {
        return this.prefillPool;
    }

    public void setPrefillPool(boolean prefillPool) {
        this.prefillPool = prefillPool;
    }

    public DestinationCreationStrategy getDestinationCreationStrategy() {
        return this.destinationCreationStrategy;
    }

    public void setDestinationCreationStrategy(DestinationCreationStrategy destinationCreationStrategy) {
        this.destinationCreationStrategy = destinationCreationStrategy;
    }

    public boolean isAllowNullBody() {
        return this.allowNullBody;
    }

    public void setAllowNullBody(boolean allowNullBody) {
        this.allowNullBody = allowNullBody;
    }

    public boolean isMapJmsMessage() {
        return this.mapJmsMessage;
    }

    public void setMapJmsMessage(boolean mapJmsMessage) {
        this.mapJmsMessage = mapJmsMessage;
    }

    public MessageCreatedStrategy getMessageCreatedStrategy() {
        return this.messageCreatedStrategy;
    }

    public void setMessageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
        this.messageCreatedStrategy = messageCreatedStrategy;
    }

    public JmsKeyFormatStrategy getJmsKeyFormatStrategy() {
        if (this.jmsKeyFormatStrategy == null) {
            this.jmsKeyFormatStrategy = new DefaultJmsKeyFormatStrategy();
        }
        return this.jmsKeyFormatStrategy;
    }

    public void setJmsKeyFormatStrategy(JmsKeyFormatStrategy jmsKeyFormatStrategy) {
        this.jmsKeyFormatStrategy = jmsKeyFormatStrategy;
    }
}

