/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jbpm.JBPMComponent;
import org.apache.camel.component.jbpm.JBPMConfiguration;
import org.apache.camel.component.jbpm.JBPMProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.remote.client.api.RemoteRestRuntimeEngineBuilder;
import org.kie.services.client.api.RemoteRuntimeEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="jbpm", title="JBPM", syntax="jbpm:connectionURL", producerOnly=true, label="process")
public class JBPMEndpoint
extends DefaultEndpoint {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(JBPMEndpoint.class);
    @UriParam
    private JBPMConfiguration configuration;

    public JBPMEndpoint(String uri, JBPMComponent component, JBPMConfiguration configuration) throws URISyntaxException, MalformedURLException {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        RemoteRestRuntimeEngineBuilder engineBuilder = RemoteRuntimeEngineFactory.newRestBuilder();
        if (this.configuration.getUserName() != null) {
            engineBuilder.addUserName(this.configuration.getUserName());
        }
        if (this.configuration.getPassword() != null) {
            engineBuilder.addPassword(this.configuration.getPassword());
        }
        if (this.configuration.getDeploymentId() != null) {
            engineBuilder.addDeploymentId(this.configuration.getDeploymentId());
        }
        if (this.configuration.getConnectionURL() != null) {
            engineBuilder.addUrl(this.configuration.getConnectionURL());
        }
        if (this.configuration.getProcessInstanceId() != null) {
            engineBuilder.addProcessInstanceId(this.configuration.getProcessInstanceId().longValue());
        }
        if (this.configuration.getTimeout() != null) {
            engineBuilder.addTimeout(this.configuration.getTimeout().intValue());
        }
        if (this.configuration.getExtraJaxbClasses() != null) {
            engineBuilder.addExtraJaxbClasses(this.configuration.getExtraJaxbClasses());
        }
        RuntimeEngine runtimeEngine = engineBuilder.build();
        return new JBPMProducer(this, runtimeEngine);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for " + ((Object)((Object)this)).getClass().getSimpleName() + " endpoint");
    }

    public boolean isSingleton() {
        return true;
    }

    public void setConfiguration(JBPMConfiguration configuration) {
        this.configuration = configuration;
    }

    public JBPMConfiguration getConfiguration() {
        return this.configuration;
    }
}

