/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.MimeMappings;
import java.nio.ByteBuffer;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.undertow.ExchangeHeaders;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCamelHandler
implements HttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowConsumer.class);
    private UndertowConsumer consumer;

    public HttpCamelHandler(UndertowConsumer consumer) {
        this.consumer = consumer;
    }

    public UndertowConsumer getConsumer() {
        return this.consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange httpExchange) throws Exception {
        HttpString requestMethod = httpExchange.getRequestMethod();
        if (Methods.OPTIONS.equals(requestMethod)) {
            String allowedMethods = this.consumer.getEndpoint().getHttpMethodRestrict() != null ? "OPTIONS" + this.consumer.getEndpoint().getHttpMethodRestrict() : "GET,HEAD,POST,PUT,DELETE,TRACE,OPTIONS,CONNECT,PATCH";
            httpExchange.setResponseCode(200);
            httpExchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_TYPE, (String)MimeMappings.DEFAULT_MIME_MAPPINGS.get("txt"));
            httpExchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_LENGTH, 0L);
            httpExchange.getResponseHeaders().put(Headers.ALLOW, allowedMethods);
            httpExchange.getResponseSender().close();
            return;
        }
        if (this.consumer.getEndpoint().getHttpMethodRestrict() != null && !this.consumer.getEndpoint().getHttpMethodRestrict().contains(requestMethod.toString())) {
            httpExchange.setResponseCode(405);
            httpExchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_TYPE, (String)MimeMappings.DEFAULT_MIME_MAPPINGS.get("txt"));
            httpExchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_LENGTH, 0L);
            httpExchange.getResponseSender().close();
            return;
        }
        if (httpExchange.isInIoThread()) {
            httpExchange.dispatch((HttpHandler)this);
            return;
        }
        Exchange camelExchange = this.consumer.getEndpoint().createExchange(httpExchange);
        this.consumer.createUoW(camelExchange);
        try {
            this.consumer.getProcessor().process(camelExchange);
        }
        catch (Exception e) {
            this.consumer.getExceptionHandler().handleException((Throwable)e);
        }
        finally {
            this.consumer.doneUoW(camelExchange);
        }
        Object body = this.getResponseBody(httpExchange, camelExchange);
        TypeConverter tc = this.consumer.getEndpoint().getCamelContext().getTypeConverter();
        if (body == null) {
            LOG.trace("No payload to send as reply for exchange: " + camelExchange);
            httpExchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_TYPE, (String)MimeMappings.DEFAULT_MIME_MAPPINGS.get("txt"));
            httpExchange.getResponseSender().send("No response available");
        } else {
            ByteBuffer bodyAsByteBuffer = (ByteBuffer)tc.convertTo(ByteBuffer.class, body);
            httpExchange.getResponseSender().send(bodyAsByteBuffer);
        }
        httpExchange.getResponseSender().close();
    }

    private Object getResponseBody(HttpServerExchange httpExchange, Exchange camelExchange) {
        Object result = camelExchange.hasOut() ? this.consumer.getEndpoint().getUndertowHttpBinding().toHttpResponse(httpExchange, camelExchange.getOut()) : this.consumer.getEndpoint().getUndertowHttpBinding().toHttpResponse(httpExchange, camelExchange.getIn());
        return result;
    }
}

