/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.Undertow;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndertowRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowRegistry.class);
    int port;
    SSLContext sslContext;
    String host;
    Undertow server;
    Map<URI, UndertowConsumer> consumersRegistry = new HashMap<URI, UndertowConsumer>();

    public UndertowRegistry(UndertowConsumer consumer, int port) {
        this.registerConsumer(consumer);
        this.port = port;
        if (consumer.getEndpoint().getSslContext() != null) {
            this.sslContext = consumer.getEndpoint().getSslContext();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void registerConsumer(UndertowConsumer consumer) {
        URI httpUri = consumer.getEndpoint().getHttpURI();
        if (this.host != null && !this.host.equals(httpUri.getHost())) {
            throw new IllegalArgumentException("Cannot register UndertowConsumer on different host and same port: {}" + this.host + " " + httpUri.getHost());
        }
        this.host = httpUri.getHost();
        LOG.info("Adding consumer to consumerRegistry: {}", (Object)httpUri);
        this.consumersRegistry.put(httpUri, consumer);
        if (this.sslContext != null && consumer.getEndpoint().getSslContext() != null) {
            throw new IllegalArgumentException("Cannot register UndertowConsumer with different SSL config");
        }
    }

    public void unregisterConsumer(UndertowConsumer consumer) {
        URI httpUri = consumer.getEndpoint().getHttpURI();
        if (this.consumersRegistry.containsKey(httpUri)) {
            this.consumersRegistry.remove(httpUri);
        } else {
            LOG.debug("Cannot unregister consumer {} as it was not registered", (Object)consumer);
        }
    }

    public boolean isEmpty() {
        return this.consumersRegistry.isEmpty();
    }

    public Undertow getServer() {
        return this.server;
    }

    public void setServer(Undertow server) {
        this.server = server;
    }

    public Map<URI, UndertowConsumer> getConsumersRegistry() {
        return this.consumersRegistry;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }
}

