/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.routebox.direct;

import org.apache.camel.AsyncProcessor;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.SuspendableService;
import org.apache.camel.component.routebox.RouteboxConsumer;
import org.apache.camel.component.routebox.RouteboxServiceSupport;
import org.apache.camel.component.routebox.direct.RouteboxDirectEndpoint;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.util.AsyncProcessorConverterHelper;

public class RouteboxDirectConsumer
extends RouteboxServiceSupport
implements RouteboxConsumer,
ShutdownAware,
SuspendableService {
    protected ProducerTemplate producer;
    private final Processor processor;
    private volatile AsyncProcessor asyncProcessor;

    public RouteboxDirectConsumer(RouteboxDirectEndpoint endpoint, Processor processor) {
        super(endpoint);
        this.processor = processor;
        this.producer = endpoint.getConfig().getInnerProducerTemplate();
    }

    protected void doStart() throws Exception {
        boolean existing;
        boolean bl = existing = this == this.getEndpoint().getConsumer();
        if (!existing && this.getEndpoint().hasConsumer(this)) {
            throw new IllegalArgumentException("Cannot add a 2nd consumer to the same endpoint. Endpoint " + (Object)((Object)this.getEndpoint()) + " only allows one consumer.");
        }
        if (!existing) {
            this.getEndpoint().addConsumer(this);
        }
        if (!this.isStartedInnerContext()) {
            this.doStartInnerContext();
        }
    }

    protected void doStop() throws Exception {
        this.getEndpoint().removeConsumer(this);
        if (this.isStartedInnerContext()) {
            this.doStopInnerContext();
        }
    }

    protected void doSuspend() throws Exception {
        this.getEndpoint().removeConsumer(this);
    }

    protected void doResume() throws Exception {
        this.doStart();
    }

    public synchronized AsyncProcessor getAsyncProcessor() {
        if (this.asyncProcessor == null) {
            this.asyncProcessor = AsyncProcessorConverterHelper.convert((Processor)this.processor);
        }
        return this.asyncProcessor;
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return true;
    }

    public int getPendingExchangesSize() {
        return 0;
    }

    public void prepareShutdown(boolean suspendOnly, boolean forced) {
    }

    public RouteboxDirectEndpoint getEndpoint() {
        return (RouteboxDirectEndpoint)this.getRouteboxEndpoint();
    }

    public Processor getProcessor() {
        return this.processor;
    }
}

