/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ServiceSupport;

public class HazelcastIdempotentRepository
extends ServiceSupport
implements IdempotentRepository<String> {
    private String repositoryName;
    private IMap<String, Boolean> repo;
    private HazelcastInstance hazelcastInstance;

    public HazelcastIdempotentRepository(HazelcastInstance hazelcastInstance) {
        this(hazelcastInstance, HazelcastIdempotentRepository.class.getSimpleName());
    }

    public HazelcastIdempotentRepository(HazelcastInstance hazelcastInstance, String repositoryName) {
        this.repositoryName = repositoryName;
        this.hazelcastInstance = hazelcastInstance;
    }

    protected void doStart() throws Exception {
        this.repo = this.hazelcastInstance.getMap(this.repositoryName);
    }

    protected void doStop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String key) {
        this.repo.lock((Object)key);
        try {
            boolean bl = this.repo.putIfAbsent((Object)key, (Object)false) == null;
            return bl;
        }
        finally {
            this.repo.unlock((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean confirm(String key) {
        this.repo.lock((Object)key);
        try {
            boolean bl = this.repo.replace((Object)key, (Object)false, (Object)true);
            return bl;
        }
        finally {
            this.repo.unlock((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String key) {
        this.repo.lock((Object)key);
        try {
            boolean bl = this.repo.containsKey((Object)key);
            return bl;
        }
        finally {
            this.repo.unlock((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String key) {
        this.repo.lock((Object)key);
        try {
            boolean bl = this.repo.remove((Object)key) != null;
            return bl;
        }
        finally {
            this.repo.unlock((Object)key);
        }
    }

    public void clear() {
        this.repo.clear();
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }
}

