/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.camel.component.dropbox.util.DropboxException;

public final class DropboxPropertyManager {
    private static Properties properties;
    private static DropboxPropertyManager instance;

    private DropboxPropertyManager() {
    }

    public static synchronized DropboxPropertyManager getInstance() throws Exception {
        if (instance == null) {
            instance = new DropboxPropertyManager();
            properties = DropboxPropertyManager.loadProperties();
        }
        return instance;
    }

    public String getProperty(String key) {
        return properties.getProperty(key);
    }

    private static Properties loadProperties() throws Exception {
        InputStream inStream;
        URL url = DropboxPropertyManager.class.getResource("/dropbox.properties");
        try {
            inStream = url.openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DropboxException("dropbox.properties could not be found");
        }
        properties = new Properties();
        try {
            properties.load(inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DropboxException("dropbox.properties can't be read");
        }
        return properties;
    }
}

