/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.dto;

import java.io.ByteArrayOutputStream;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.dropbox.dto.DropboxResult;
import org.apache.camel.component.dropbox.util.DropboxResultHeader;

public class DropboxFileDownloadResult
extends DropboxResult {
    @Override
    public void populateExchange(Exchange exchange) {
        Map map = (Map)this.resultEntries;
        if (map.size() == 1) {
            String pathExtracted = null;
            ByteArrayOutputStream baosExtracted = null;
            for (Map.Entry entry : map.entrySet()) {
                pathExtracted = (String)entry.getKey();
                baosExtracted = (ByteArrayOutputStream)entry.getValue();
            }
            exchange.getIn().setHeader(DropboxResultHeader.DOWNLOADED_FILE.name(), pathExtracted);
            exchange.getIn().setBody(baosExtracted);
        } else {
            StringBuffer pathsExtracted = new StringBuffer();
            for (Map.Entry entry : map.entrySet()) {
                pathsExtracted.append((String)entry.getKey() + "\n");
            }
            exchange.getIn().setHeader(DropboxResultHeader.DOWNLOADED_FILES.name(), (Object)pathsExtracted.toString());
            exchange.getIn().setBody((Object)map);
        }
    }
}

