/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.core;

import com.dropbox.core.DbxClient;
import com.dropbox.core.DbxEntry;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxWriteMode;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.dropbox.dto.DropboxDelResult;
import org.apache.camel.component.dropbox.dto.DropboxFileDownloadResult;
import org.apache.camel.component.dropbox.dto.DropboxFileUploadResult;
import org.apache.camel.component.dropbox.dto.DropboxMoveResult;
import org.apache.camel.component.dropbox.dto.DropboxResult;
import org.apache.camel.component.dropbox.dto.DropboxSearchResult;
import org.apache.camel.component.dropbox.util.DropboxException;
import org.apache.camel.component.dropbox.util.DropboxResultCode;
import org.apache.camel.component.dropbox.util.DropboxUploadMode;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DropboxAPIFacade {
    private static final transient Logger LOG = LoggerFactory.getLogger(DropboxAPIFacade.class);
    private static DropboxAPIFacade instance;
    private static DbxClient client;

    private DropboxAPIFacade() {
    }

    public static DropboxAPIFacade getInstance(DbxClient client) {
        if (instance == null) {
            instance = new DropboxAPIFacade();
            DropboxAPIFacade.client = client;
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DropboxResult put(String localPath, String remotePath, DropboxUploadMode mode) throws DropboxException {
        DropboxFileUploadResult result = new DropboxFileUploadResult();
        HashMap<String, DropboxResultCode> resultEntries = null;
        String dropboxPath = remotePath == null ? localPath : remotePath;
        DbxEntry entry = null;
        try {
            entry = client.getMetadata(dropboxPath);
        }
        catch (DbxException e) {
            throw new DropboxException(dropboxPath + " does not exist or can't obtain metadata");
        }
        File fileLocalPath = new File(localPath);
        if (fileLocalPath.isFile()) {
            if (entry != null && !entry.isFile()) {
                throw new DropboxException(dropboxPath + " exists on dropbox and is not a file!");
            }
            if (entry == null && dropboxPath.endsWith("/")) {
                dropboxPath = dropboxPath + fileLocalPath.getName();
            }
            resultEntries = new HashMap<String, DropboxResultCode>(1);
            try {
                DbxEntry.File uploadedFile = this.putSingleFile(fileLocalPath, dropboxPath, mode);
                if (uploadedFile == null) {
                    resultEntries.put(dropboxPath, DropboxResultCode.KO);
                } else {
                    resultEntries.put(dropboxPath, DropboxResultCode.OK);
                }
            }
            catch (Exception ex) {
                resultEntries.put(dropboxPath, DropboxResultCode.KO);
            }
            finally {
                result.setResultEntries(resultEntries);
            }
            return result;
        }
        LOG.info("uploading a dir...");
        if (entry != null && !entry.isFolder()) {
            throw new DropboxException(dropboxPath + " exists on dropbox and is not a folder!");
        }
        if (!dropboxPath.endsWith("/")) {
            dropboxPath = dropboxPath + "/";
        }
        String oldDropboxPath = dropboxPath;
        Collection listFiles = FileUtils.listFiles((File)fileLocalPath, null, (boolean)true);
        if (listFiles == null || listFiles.isEmpty()) {
            throw new DropboxException(localPath + " doesn't contain any files");
        }
        resultEntries = new HashMap(listFiles.size());
        for (File file : listFiles) {
            String absPath = file.getAbsolutePath();
            int indexRemainingPath = localPath.length();
            if (!localPath.endsWith("/")) {
                ++indexRemainingPath;
            }
            String remainingPath = absPath.substring(indexRemainingPath);
            dropboxPath = dropboxPath + remainingPath;
            try {
                LOG.info("uploading:" + fileLocalPath + "," + dropboxPath);
                DbxEntry.File uploadedFile = this.putSingleFile(file, dropboxPath, mode);
                if (uploadedFile == null) {
                    resultEntries.put(dropboxPath, DropboxResultCode.KO);
                } else {
                    resultEntries.put(dropboxPath, DropboxResultCode.OK);
                }
            }
            catch (Exception ex) {
                resultEntries.put(dropboxPath, DropboxResultCode.KO);
            }
            dropboxPath = oldDropboxPath;
        }
        result.setResultEntries(resultEntries);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbxEntry.File putSingleFile(File inputFile, String dropboxPath, DropboxUploadMode mode) throws Exception {
        DbxEntry.File uploadedFile = null;
        try (FileInputStream inputStream = new FileInputStream(inputFile);){
            DbxWriteMode uploadMode = null;
            uploadMode = mode == DropboxUploadMode.force ? DbxWriteMode.force() : DbxWriteMode.add();
            DbxEntry.File file = uploadedFile = client.uploadFile(dropboxPath, uploadMode, inputFile.length(), (InputStream)inputStream);
            return file;
        }
    }

    public DropboxResult search(String remotePath, String query) throws DropboxException {
        DropboxSearchResult result = new DropboxSearchResult();
        DbxEntry.WithChildren listing = null;
        if (query == null) {
            LOG.info("search no query");
            try {
                listing = client.getMetadataWithChildren(remotePath);
            }
            catch (DbxException e) {
                throw new DropboxException(remotePath + " does not exist or can't obtain metadata");
            }
            result.setResultEntries(listing.children);
        } else {
            LOG.info("search by query:" + query);
            List entries = null;
            try {
                entries = client.searchFileAndFolderNames(remotePath, query);
            }
            catch (DbxException e) {
                throw new DropboxException(remotePath + " does not exist or can't obtain metadata");
            }
            result.setResultEntries(entries);
        }
        return result;
    }

    public DropboxResult del(String remotePath) throws DropboxException {
        DropboxDelResult result = null;
        try {
            client.delete(remotePath);
        }
        catch (DbxException e) {
            throw new DropboxException(remotePath + " does not exist or can't obtain metadata");
        }
        result = new DropboxDelResult();
        result.setResultEntries(remotePath);
        return result;
    }

    public DropboxResult move(String remotePath, String newRemotePath) throws DropboxException {
        DropboxMoveResult result = null;
        try {
            client.move(remotePath, newRemotePath);
        }
        catch (DbxException e) {
            throw new DropboxException(remotePath + " does not exist or can't obtain metadata");
        }
        result = new DropboxMoveResult();
        result.setResultEntries(remotePath + "-" + newRemotePath);
        return result;
    }

    public DropboxResult get(String remotePath) throws DropboxException {
        DropboxFileDownloadResult result = new DropboxFileDownloadResult();
        HashMap<String, ByteArrayOutputStream> resultEntries = new HashMap<String, ByteArrayOutputStream>();
        this.downloadFilesInFolder(remotePath, resultEntries);
        result.setResultEntries(resultEntries);
        return result;
    }

    private void downloadFilesInFolder(String path, Map<String, ByteArrayOutputStream> resultEntries) throws DropboxException {
        DbxEntry.WithChildren listing = null;
        try {
            listing = client.getMetadataWithChildren(path);
        }
        catch (DbxException e) {
            throw new DropboxException(path + " does not exist or can't obtain metadata");
        }
        if (listing.children == null) {
            LOG.info("downloading a single file...");
            this.downloadSingleFile(path, resultEntries);
            return;
        }
        for (DbxEntry entry : listing.children) {
            if (entry.isFile()) {
                try {
                    this.downloadSingleFile(entry.path, resultEntries);
                }
                catch (DropboxException e) {
                    LOG.warn("can't download from " + entry.path);
                }
                continue;
            }
            this.downloadFilesInFolder(entry.path, resultEntries);
        }
    }

    private void downloadSingleFile(String path, Map<String, ByteArrayOutputStream> resultEntries) throws DropboxException {
        DbxEntry.File downloadedFile;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            downloadedFile = client.getFile(path, null, (OutputStream)baos);
        }
        catch (DbxException e) {
            throw new DropboxException(path + " does not exist or can't obtain metadata");
        }
        catch (IOException e) {
            throw new DropboxException(path + " can't obtain a stream");
        }
        if (downloadedFile != null) {
            resultEntries.put(path, baos);
            LOG.info("downloaded path:" + path + " - baos size:" + baos.size());
        }
    }
}

