/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ganglia;

import info.ganglia.gmetric4j.Publisher;
import info.ganglia.gmetric4j.gmetric.GMetricSlope;
import info.ganglia.gmetric4j.gmetric.GMetricType;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.ganglia.GangliaConfiguration;
import org.apache.camel.component.ganglia.GangliaEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class GangliaProducer
extends DefaultProducer {
    private final Publisher publisher;
    private final GangliaEndpoint gangliaEndpoint;

    public GangliaProducer(GangliaEndpoint endpoint, Publisher publisher) {
        super((Endpoint)endpoint);
        this.gangliaEndpoint = endpoint;
        this.publisher = publisher;
    }

    public void process(Exchange exchange) throws Exception {
        String value;
        Message message = exchange.getIn();
        GangliaConfiguration conf = this.gangliaEndpoint.getConfiguration();
        String groupName = conf.getGroupName();
        if (message.getHeaders().containsKey("CamelGangliaGroupName")) {
            groupName = (String)message.getHeader("CamelGangliaGroupName", String.class);
        }
        String prefix = conf.getPrefix();
        String metricName = conf.getMetricName();
        if (message.getHeaders().containsKey("CamelGangliaMetricName")) {
            metricName = (String)message.getHeader("CamelGangliaMetricName", String.class);
        }
        if (prefix != null && prefix.length() > 0) {
            metricName = prefix + "_" + metricName;
        }
        GMetricType type = conf.getType();
        if (message.getHeaders().containsKey("CamelGangliaMetricType")) {
            type = (GMetricType)message.getHeader("CamelGangliaMetricType", GMetricType.class);
        }
        GMetricSlope slope = conf.getSlope();
        if (message.getHeaders().containsKey("CamelGangliaMetricSlope")) {
            slope = (GMetricSlope)message.getHeader("CamelGangliaMetricSlope", GMetricSlope.class);
        }
        String units = conf.getUnits();
        if (message.getHeaders().containsKey("CamelGangliaMetricUnits")) {
            units = (String)message.getHeader("CamelGangliaMetricUnits", String.class);
        }
        int tmax = conf.getTmax();
        if (message.getHeaders().containsKey("CamelGangliaMetricTmax")) {
            tmax = (Integer)message.getHeader("CamelGangliaMetricTmax", Integer.class);
        }
        int dmax = conf.getDmax();
        if (message.getHeaders().containsKey("CamelGangliaMetricDmax")) {
            dmax = (Integer)message.getHeader("CamelGangliaMetricDmax", Integer.class);
        }
        if (!((value = (String)message.getBody(String.class)) != null && value.length() != 0 || type != GMetricType.FLOAT && type != GMetricType.DOUBLE)) {
            this.log.debug("Metric {} string value was null, using NaN", (Object)metricName);
            value = "NaN";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending metric {} to Ganglia: {}", (Object)metricName, (Object)value);
        }
        this.publisher.publish(groupName, metricName, value, type, slope, tmax, dmax, units);
        this.log.trace("Sending metric done");
    }
}

